% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matingPlot.R
\name{plotScene}
\alias{plotScene}
\title{graphical visualization of a mating scene object}
\usage{
plotScene(scene, dimension = "auto", opening = NULL, closing = NULL,
  dailyPoints = TRUE, drawQuartiles = TRUE, sub = NULL, N = 1,
  xlab.spat = NULL, ylab.spat = NULL, pch = 19, pt.cex = 0.75,
  text.cex = 0.6, quartile.lwd = 1, quartile.col = "gray55",
  peak.col = "gray27", labelID = FALSE, mt1 = "F", mt2 = "M", ...)
}
\arguments{
\item{scene}{a matingScene object}

\item{dimension}{what dimension(s) of the mating scene should be visualized. Possible dimensions are 't' for temporal, 's' for spatial, 'mt' for mating type, and 'auto' (the default). For dimension = 'auto', all dimensions represented in the mating scene object will be plotted.}

\item{opening}{the number of days to adjust the start date displayed for the temporal dimension. Start date defaults to minimum day of year of start date in mating scene object.}

\item{closing}{the number of days to adjust the end date displayed for the temporal dimension. End date defaults to maximum day of year end date in mating scene object.}

\item{dailyPoints}{logical indicating whether daily counts of individuals should be displayed for plots of the temporal dimension}

\item{drawQuartiles}{logical indicating whether vertical lines should be drawn at population peak (see details) or quartiles}

\item{sub}{a vector containing the ids of individuals to be highlighted in the plots or a character string specifying how to choose individuals to highlight. Possible values are "random" or "all". If NULL, no subset will be identified in the plots.}

\item{N}{a positive number, the number of individuals to sample if \code{sub} = 'random'}

\item{xlab.spat}{character label for x-axis of spatial dimension plots. If NULL, defaults to 'easting'.}

\item{ylab.spat}{character label for y-axis of spatial dimension plots. If NULL, defaults to 'northing'.}

\item{pch}{specify point type to be used in plots. Defaults to pch = 19 (filled-in circle). If NULL, points will be labeled with their id.}

\item{pt.cex}{specify point expansion factor (point size relative to device default)}

\item{text.cex}{specify text expansion factor (text size relative to device default)}

\item{quartile.lwd}{if \code{drawQuartiles} = TRUE, specifies weight of quartile and peak lines relative to device default.}

\item{quartile.col}{if \code{drawQuartiles} = TRUE, specifies color of quartile lines, defaults to 'gray81'.}

\item{peak.col}{if \code{drawQuartiles} = TRUE, specify color of peak lines, defaults to 'gray27'.}

\item{labelID}{if TRUE, the y-axis will be labeled with the id of the corresponding segment.}

\item{mt1}{label for mating type '1', if dioecious}

\item{mt2}{label for mating type '2', if dioecious}

\item{...}{standard graphical parameters}
}
\value{
nothing

optional arguments for the plot function
}
\description{
Visualize a mating scene
}
\details{
Population peak is defined by when maximum number individuals were reproductively receptive on one day. If multiple days had the same maximum number, peak is defined as the median of these dates.
}
\examples{
pop <- simulateScene()
plotScene(pop)
\dontrun{plotMap(NULL)}


}
\author{
Amy Waananen
}
\seealso{
see \code{\link{plot3DScene}} to visualize multiple dimensions on one plot
}

