/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search.limit;

import choco.IPretty;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.limit.Limit;

public abstract class AbstractGlobalSearchLimit
implements IPretty {
    protected final AbstractGlobalSearchStrategy strategy;
    protected final String unit;
    protected final Limit type;
    protected int nbMax;

    public AbstractGlobalSearchLimit(AbstractGlobalSearchStrategy theStrategy, int theLimit, String unit) {
        this.strategy = theStrategy;
        this.nbMax = theLimit;
        this.type = null;
        this.unit = unit;
    }

    public AbstractGlobalSearchLimit(AbstractGlobalSearchStrategy theStrategy, int theLimit, Limit type) {
        this.strategy = theStrategy;
        this.nbMax = theLimit;
        this.type = type;
        this.unit = type.getUnit();
    }

    public final AbstractGlobalSearchStrategy getSearchStrategy() {
        return this.strategy;
    }

    public String toString() {
        return this.pretty();
    }

    @Override
    public String pretty() {
        StringBuilder b = new StringBuilder();
        b.append(this.getNb());
        if (this.nbMax != Integer.MAX_VALUE) {
            b.append('/').append(this.nbMax);
        }
        b.append(' ').append(this.unit);
        return new String(b);
    }

    public abstract int getNb();

    public final int getNbMax() {
        return this.nbMax;
    }

    public void setNbMax(int nbMax) {
        this.nbMax = nbMax;
    }

    public final Limit getType() {
        return this.type;
    }

    public final String getUnit() {
        return this.unit;
    }
}

