/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling;

import choco.cp.solver.constraints.global.scheduling.AbstractResourceSConstraint;
import choco.kernel.common.util.tools.TaskUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;
import choco.kernel.solver.variables.scheduling.TaskVar;

public class RTask
implements IRTask {
    public final AbstractResourceSConstraint resource;
    public final int taskIdx;
    public final TaskVar taskvar;
    protected ITask htask;
    public final IntDomainVar usage;
    public final IntDomainVar height;
    private int value;

    public RTask(AbstractResourceSConstraint constraint, int taskIdx) {
        this.resource = constraint;
        this.taskIdx = taskIdx;
        this.taskvar = constraint.getTask(taskIdx);
        this.usage = (IntDomainVar)constraint.getVar(constraint.getUsageIndex(taskIdx));
        this.height = (IntDomainVar)constraint.getVar(constraint.getHeightIndex(taskIdx));
        this.htask = this.taskvar;
        if (this.getUsage().getInf() < 0 || this.getUsage().getSup() > 1) {
            throw new SolverException(this.getUsage().pretty() + " is not a boolean variable.");
        }
    }

    @Override
    public final int getTaskIndex() {
        return this.taskIdx;
    }

    @Override
    public final int getStoredValue() {
        return this.value;
    }

    @Override
    public final void storeValue(int val) {
        this.value = val;
    }

    @Override
    public final TaskVar getTaskVar() {
        return this.taskvar;
    }

    @Override
    public final ITask getHTask() {
        return this.htask;
    }

    @Override
    public void checkConsistency() throws ContradictionException {
        this.updateCompulsoryPart();
    }

    @Override
    public final boolean updateECT() throws ContradictionException {
        return this.updateECT(this.value);
    }

    @Override
    public final boolean updateEST() throws ContradictionException {
        return this.updateEST(this.value);
    }

    @Override
    public final boolean updateLCT() throws ContradictionException {
        return this.updateLCT(this.value);
    }

    @Override
    public final boolean updateLST() throws ContradictionException {
        return this.updateLST(this.value);
    }

    @Override
    public boolean updateDuration(int duration) throws ContradictionException {
        if (this.setDuration(duration)) {
            this.updateCompulsoryPart();
            return true;
        }
        return false;
    }

    @Override
    public boolean updateECT(int val) throws ContradictionException {
        if (this.setECT(val)) {
            this.updateCompulsoryPart();
            return true;
        }
        return false;
    }

    @Override
    public boolean updateEndingTime(int endingTime) throws ContradictionException {
        if (this.setEndingTime(endingTime)) {
            this.updateCompulsoryPart();
            return true;
        }
        return false;
    }

    @Override
    public boolean updateEndNotIn(int a, int b) throws ContradictionException {
        if (this.setEndNotIn(a, b)) {
            this.updateCompulsoryPart();
            return true;
        }
        return false;
    }

    @Override
    public boolean updateEST(int val) throws ContradictionException {
        if (this.setEST(val)) {
            this.updateCompulsoryPart();
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLCT(int val) throws ContradictionException {
        if (this.setLCT(val)) {
            this.updateCompulsoryPart();
            return true;
        }
        return false;
    }

    @Override
    public boolean updateLST(int val) throws ContradictionException {
        if (this.setLST(val)) {
            this.updateCompulsoryPart();
            return true;
        }
        return false;
    }

    @Override
    public boolean updateMaxDuration(int val) throws ContradictionException {
        if (this.setMaxDuration(val)) {
            this.updateCompulsoryPart();
            return true;
        }
        return false;
    }

    @Override
    public boolean updateMinDuration(int val) throws ContradictionException {
        if (this.setMinDuration(val)) {
            this.updateCompulsoryPart();
            return true;
        }
        return false;
    }

    @Override
    public boolean updateStartingTime(int startingTime) throws ContradictionException {
        if (this.setStartingTime(startingTime)) {
            this.updateCompulsoryPart();
            return true;
        }
        return false;
    }

    @Override
    public boolean updateStartNotIn(int a, int b) throws ContradictionException {
        if (this.setStartNotIn(a, b)) {
            this.updateCompulsoryPart();
            return true;
        }
        return false;
    }

    @Override
    public boolean setDuration(int duration) throws ContradictionException {
        assert (this.isRegular());
        return this.taskvar.duration().instantiate(duration, this.resource, false);
    }

    @Override
    public boolean setStartingTime(int startingTime) throws ContradictionException {
        assert (this.isRegular());
        return this.taskvar.start().instantiate(startingTime, this.resource, false);
    }

    @Override
    public boolean setEndingTime(int endingTime) throws ContradictionException {
        assert (this.isRegular());
        return this.taskvar.end().instantiate(endingTime, this.resource, false);
    }

    @Override
    public boolean setEndNotIn(int a, int b) throws ContradictionException {
        assert (this.isRegular());
        return this.taskvar.end().removeInterval(a, b, this.resource, false);
    }

    @Override
    public boolean setStartNotIn(int min, int max) throws ContradictionException {
        assert (this.isRegular());
        return this.taskvar.start().removeInterval(min, max, this.resource, false);
    }

    @Override
    public boolean setECT(int val) throws ContradictionException {
        assert (this.isRegular());
        return this.taskvar.end().updateInf(val, this.resource, false);
    }

    @Override
    public boolean setEST(int val) throws ContradictionException {
        assert (this.isRegular());
        return this.taskvar.start().updateInf(val, this.resource, false);
    }

    @Override
    public boolean setLCT(int val) throws ContradictionException {
        assert (this.isRegular());
        return this.taskvar.end().updateSup(val, this.resource, false);
    }

    @Override
    public boolean setLST(int val) throws ContradictionException {
        assert (this.isRegular());
        return this.taskvar.start().updateSup(val, this.resource, false);
    }

    @Override
    public boolean setMaxDuration(int val) throws ContradictionException {
        assert (this.isRegular());
        return this.taskvar.duration().updateSup(val, this.resource, false);
    }

    @Override
    public boolean setMinDuration(int val) throws ContradictionException {
        assert (this.isRegular());
        return this.taskvar.duration().updateInf(val, this.resource, false);
    }

    @Override
    public final void updateCompulsoryPart() throws ContradictionException {
        this.taskvar.updateCompulsoryPart(this.resource);
    }

    @Override
    public final void fail() throws ContradictionException {
        this.resource.fail();
    }

    @Override
    public final IntDomainVar getUsage() {
        return this.usage;
    }

    @Override
    public boolean assign() throws ContradictionException {
        return this.usage.instantiate(1, this.resource, false);
    }

    @Override
    public final boolean isOptional() {
        return !this.usage.isInstantiated();
    }

    @Override
    public final boolean isRegular() {
        return this.usage.isInstantiatedTo(1);
    }

    @Override
    public final boolean isEliminated() {
        return this.usage.isInstantiatedTo(0);
    }

    @Override
    public final boolean remove() throws ContradictionException {
        return this.usage.instantiate(0, this.resource, false);
    }

    @Override
    public final void fireRemoval() {
        assert (this.isEliminated());
        this.resource.fireTaskRemoval(this);
    }

    @Override
    public final IntDomainVar getHeight() {
        return this.height;
    }

    @Override
    public final boolean updateMaxHeight(int val) throws ContradictionException {
        return this.height.updateSup(val, this.resource, false);
    }

    @Override
    public final boolean updateMinHeight(int val) throws ContradictionException {
        return this.height.updateInf(val, this.resource, false);
    }

    @Override
    public final int getMaxHeight() {
        return this.getHeight().getSup();
    }

    @Override
    public final int getMinHeight() {
        return this.getHeight().getInf();
    }

    @Override
    public final long getMaxConsumption() {
        return TaskUtils.getMaxConsumption(this);
    }

    @Override
    public final long getMinConsumption() {
        return TaskUtils.getMinConsumption(this);
    }

    public String toString() {
        return this.getHTask().toString();
    }

    @Override
    public String pretty() {
        return this.getHTask().pretty();
    }
}

