/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.objects;

import choco.kernel.common.logging.ChocoLogging;
import gnu.trove.TObjectIntHashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BipartiteSet<E> {
    private static final Logger LOGGER = ChocoLogging.getEngineLogger();
    private E[] objects = new Object[16];
    private int size;
    private int nbLeft = 0;
    private TObjectIntHashMap<E> indices = new TObjectIntHashMap();

    public void clear() {
        this.size = 0;
        this.nbLeft = 0;
        this.indices.clear();
    }

    private void swap(int idx1, int idx2) {
        if (idx1 != idx2) {
            E obj2;
            E obj1 = this.objects[idx1];
            this.objects[idx1] = obj2 = this.objects[idx2];
            this.objects[idx2] = obj1;
            this.indices.put(obj1, idx2);
            this.indices.put(obj2, idx1);
        }
    }

    public void moveLeft(E object) {
        if (!this.indices.contains(object)) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.logp(Level.SEVERE, "BipartiteSet", "moveLeft", "bipartite set does not contain " + object);
            }
        } else {
            int idx = this.indices.get(object);
            if (idx >= this.nbLeft) {
                this.swap(idx, this.nbLeft++);
            }
        }
    }

    public void moveRight(E object) {
        if (!this.indices.contains(object)) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.logp(Level.SEVERE, "BipartiteSet", "moveRight", "bipartite set does not contain " + object);
            }
        } else {
            int idx = this.indices.get(object);
            if (idx < this.nbLeft) {
                this.swap(idx, --this.nbLeft);
            }
        }
    }

    public void moveAllLeft() {
        this.nbLeft = this.size;
    }

    public void moveAllRight() {
        this.nbLeft = 0;
    }

    public void addRight(E object) {
        if (this.indices.containsKey(object)) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.logp(Level.SEVERE, "BipartiteSet", "addRight", object + "already in the set bipartite set ");
            }
        } else {
            this.ensureCapacity(this.size + 1);
            this.objects[this.size++] = object;
            this.indices.put(object, this.size - 1);
        }
    }

    private void ensureCapacity(int newSize) {
        if (newSize > this.objects.length) {
            E[] tmp = this.objects;
            this.objects = new Object[this.size * 3 / 2 + 1];
            System.arraycopy(tmp, 0, this.objects, 0, this.size);
        }
    }

    public void addLeft(E object) {
        this.addRight(object);
        this.moveLeft(object);
    }

    public boolean isLeft(E object) {
        if (!this.indices.contains(object)) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.logp(Level.SEVERE, "BipartiteSet", "isLeft", "bipartite set does not contain " + object);
            }
            return false;
        }
        return this.indices.get(object) < this.nbLeft;
    }

    public boolean isIn(E object) {
        return this.indices.containsKey(object);
    }

    public int getNbLeft() {
        return this.nbLeft;
    }

    public int getNbRight() {
        return this.size - this.nbLeft;
    }

    public int getNbObjects() {
        return this.size;
    }

    public E moveLastLeft() {
        if (this.nbLeft > 0) {
            return this.objects[--this.nbLeft];
        }
        return null;
    }

    public Iterator<E> leftIterator() {
        return new LeftItr();
    }

    public Iterator<E> rightIterator() {
        return new RightItr();
    }

    private final class RightItr
    implements Iterator<E> {
        private int cursor;

        private RightItr() {
            this.cursor = BipartiteSet.this.nbLeft;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != BipartiteSet.this.size;
        }

        @Override
        public E next() {
            return BipartiteSet.this.objects[this.cursor++];
        }

        @Override
        public void remove() {
        }
    }

    private final class LeftItr
    implements Iterator<E> {
        private int cursor = 0;

        private LeftItr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != BipartiteSet.this.nbLeft;
        }

        @Override
        public E next() {
            return BipartiteSet.this.objects[this.cursor++];
        }

        @Override
        public void remove() {
        }
    }
}

