/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.model.managers.constraints.global;

import choco.cp.model.managers.IntConstraintManager;
import choco.cp.solver.CPSolver;
import choco.cp.solver.constraints.integer.Element;
import choco.cp.solver.constraints.integer.Element2D;
import choco.cp.solver.constraints.integer.ElementG;
import choco.cp.solver.constraints.integer.ElementV;
import choco.cp.solver.constraints.integer.ElementVG;
import choco.cp.solver.constraints.reified.ExpressionSConstraint;
import choco.cp.solver.constraints.reified.leaves.VariableLeaf;
import choco.cp.solver.constraints.reified.leaves.bool.AndNode;
import choco.cp.solver.constraints.reified.leaves.bool.EqNode;
import choco.cp.solver.constraints.reified.leaves.bool.NeqNode;
import choco.cp.solver.constraints.reified.leaves.bool.OrNode;
import choco.kernel.model.ModelException;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerConstantVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.Solver;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.integer.IntExp;
import choco.kernel.solver.constraints.reified.INode;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.List;

public final class ElementManager
extends IntConstraintManager {
    public SConstraint makeConstraint(Solver solver, IntegerVariable[] variables, Object parameters, List<String> options) {
        if (solver instanceof CPSolver) {
            if (parameters instanceof Integer) {
                int offset = (Integer)parameters;
                IntDomainVar index = solver.getVar(variables[variables.length - 2]);
                IntDomainVar val = solver.getVar(variables[variables.length - 1]);
                int[] values = new int[variables.length - 2];
                boolean areConstants = true;
                for (int i = 0; i < variables.length - 2; ++i) {
                    if (!variables[i].getVariableType().equals((Object)VariableType.CONSTANT_INTEGER)) {
                        areConstants = false;
                        break;
                    }
                    values[i] = ((IntegerConstantVariable)variables[i]).getValue();
                }
                if (areConstants) {
                    if (options.contains("cp:G")) {
                        return new ElementG(index, values, val, solver.getEnvironment());
                    }
                    return new Element(index, values, val, offset);
                }
                if (index.hasEnumeratedDomain()) {
                    if (options.contains("cp:G")) {
                        return new ElementVG(solver.getVar(variables), offset, solver.getEnvironment());
                    }
                    return new ElementV(solver.getVar(variables), offset, solver.getEnvironment());
                }
                throw new SolverException(index.getName() + " has not an enumerated domain");
            }
            if (parameters instanceof int[][]) {
                int[][] varArray = (int[][])parameters;
                IntDomainVar index = solver.getVar(variables[0]);
                IntDomainVar index2 = solver.getVar(variables[1]);
                IntDomainVar val = solver.getVar(variables[2]);
                return new Element2D(index, index2, val, varArray);
            }
        }
        throw new ModelException("Could not found a constraint manager in " + this.getClass() + " !");
    }

    @Override
    public SConstraint[] makeConstraintAndOpposite(Solver solver, IntegerVariable[] variables, Object parameters, List<String> options) {
        SConstraint[] cs = new SConstraint[2];
        if (solver instanceof CPSolver) {
            if (parameters instanceof Integer) {
                int offset = (Integer)parameters;
                IntDomainVar x = solver.getVar(variables[variables.length - 2]);
                IntDomainVar y = x.hasBooleanDomain() ? solver.createBooleanVar("Y_opp") : (x.hasEnumeratedDomain() ? solver.createEnumIntVar("Y_opp", x.getInf(), x.getSup()) : solver.createBoundIntVar("Y_opp", x.getInf(), x.getSup()));
                IntDomainVar val = solver.getVar(variables[variables.length - 1]);
                if (variables[0] instanceof IntegerConstantVariable) {
                    int[] values = new int[variables.length - 2];
                    for (int i = 0; i < variables.length - 2; ++i) {
                        values[i] = ((IntegerConstantVariable)variables[i]).getValue();
                    }
                    if (options.contains("cp:G")) {
                        solver.post(new ElementG(y, values, val, solver.getEnvironment()));
                    } else {
                        solver.post(new Element(y, values, val, offset));
                    }
                } else if (y.hasEnumeratedDomain()) {
                    IntDomainVar[] tvars = solver.getVar(variables);
                    tvars[variables.length - 2] = y;
                    if (options.contains("cp:G")) {
                        solver.post(new ElementVG(tvars, offset, solver.getEnvironment()));
                    } else {
                        solver.post(new ElementV(tvars, offset, solver.getEnvironment()));
                    }
                } else {
                    throw new SolverException(x.getName() + " has not an enumerated domain");
                }
                cs[0] = solver.eq((IntExp)y, (IntExp)x);
                cs[1] = solver.neq((IntExp)y, (IntExp)x);
            } else if (parameters instanceof int[][]) {
                int[][] varArray = (int[][])parameters;
                IntDomainVar x1 = solver.getVar(variables[0]);
                IntDomainVar x2 = solver.getVar(variables[1]);
                IntDomainVar y1 = x1.hasBooleanDomain() ? solver.createBooleanVar("Y1_opp") : (x1.hasEnumeratedDomain() ? solver.createEnumIntVar("Y1_opp", x1.getInf(), x1.getSup()) : solver.createBoundIntVar("Y1_opp", x1.getInf(), x1.getSup()));
                IntDomainVar y2 = x2.hasBooleanDomain() ? solver.createBooleanVar("Y2_opp") : (x2.hasEnumeratedDomain() ? solver.createEnumIntVar("Y2_opp", x2.getInf(), x2.getSup()) : solver.createBoundIntVar("Y2_opp", x2.getInf(), x2.getSup()));
                IntDomainVar val = solver.getVar(variables[2]);
                solver.post(new Element2D(y1, y2, val, varArray));
                cs[0] = new ExpressionSConstraint(new AndNode(new EqNode(new INode[]{new VariableLeaf(y1), new VariableLeaf(x1)}), new EqNode(new INode[]{new VariableLeaf(y2), new VariableLeaf(x2)})));
                cs[1] = new ExpressionSConstraint(new OrNode(new NeqNode(new INode[]{new VariableLeaf(y1), new VariableLeaf(x1)}), new NeqNode(new INode[]{new VariableLeaf(y2), new VariableLeaf(x2)})));
            }
            return cs;
        }
        throw new ModelException("Could not found a node manager in " + this.getClass() + " !");
    }
}

