% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabsim.R
\name{stabsim}
\alias{stabsim}
\title{Simulated data for group formation problem}
\usage{
stabsim(m, ind, seed = 123, singles = NULL, gpm = 2)
}
\arguments{
\item{m}{integer indicating the number of markets to be simulated.}

\item{ind}{integer (or vector) indicating the number of individuals per group.}

\item{seed}{integer setting the state for random number generation. Defaults to \code{set.seed(123)}.}

\item{singles}{integer giving the number of one-group markets.}

\item{gpm}{integer giving the number of groups per market.}
}
\value{
\code{stabsim} returns a data frame with the randomly generated variables 
mimicking those in dataset \code{\link{baac00}}.
\item{m.id}{categorical: market identifier.}
\item{g.id}{categorical: group identifier.}
\item{wst}{binary: indicator taking the value 1 if last year was worse than the year before; 0 otherwise.}
\item{R}{NA: group outcome is not simulated. It can be obtained using the  \code{simulation} argument 
in function \code{stabit}.}
}
\description{
Simulate individual-level data for one-sided matching markets.
}
\examples{
## Coalitions [gpm := 2 !]
## Simulate one-sided matching data for 4 markets (m=4) with 2 groups
## per market (gpm=2) and 2 to 4 individuals per group (ind=2:4)
 idata <- stabsim(m=4, ind=2:4, seed=124, singles=2, gpm=2)  

## Rommmates [ind := 2 !]
## Simulate one-sided matching data for 3 markets (m=3) with 3 groups
## per market (gpm=3) and 2 individuals per group (ind=2)
 idata <- stabsim(m=3, ind=2, seed=124, gpm=3)
}
\author{
Thilo Klein
}
\keyword{generate}

