/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.structure.iterators;

import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.memory.IStateInt;
import java.util.NoSuchElementException;

public final class PSVIterator<E>
extends DisposableIterator<E> {
    private int nStaticObjects;
    private int nStoredObjects;
    private E[] staticObjects;
    private E[] storedObjects;
    private int idx;

    public void init(int theNStaticObjects, E[] theStaticObjects, IStateInt theNStoredObjects, E[] theStoredObjects) {
        super.init();
        this.idx = -1;
        this.nStaticObjects = theNStaticObjects;
        this.staticObjects = theStaticObjects;
        this.nStoredObjects = theNStoredObjects.get();
        this.storedObjects = theStoredObjects;
    }

    @Override
    public boolean hasNext() {
        if (this.idx < 1000000) {
            return this.idx + 1 < this.nStaticObjects || this.nStoredObjects > 0;
        }
        return this.idx + 1 < 1000000 + this.nStoredObjects;
    }

    @Override
    public E next() {
        if (this.idx < 1000000) {
            if (this.idx + 1 < this.nStaticObjects) {
                ++this.idx;
                while (this.staticObjects[this.idx] == null && this.idx < this.nStaticObjects) {
                    ++this.idx;
                }
                return this.staticObjects[this.idx];
            }
            if (this.nStoredObjects > 0) {
                this.idx = 1000000;
                return this.storedObjects[0];
            }
            throw new NoSuchElementException();
        }
        if (this.idx + 1 < 1000000 + this.nStoredObjects) {
            return this.storedObjects[++this.idx - 1000000];
        }
        throw new NoSuchElementException();
    }
}

