% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchMulti-internal.R
\name{sdiff}
\alias{sdiff}
\alias{ttest.balance}
\alias{fisher.balance}
\alias{wilc.balance}
\title{Balance Measures}
\usage{
sdiff(varname, treatment, orig.data, match.data = NULL)
}
\arguments{
\item{varname}{name of the variable on which to test balance}

\item{treatment}{name of the binary indicator for treatment status}

\item{orig.data}{a data frame containing the data before matching}

\item{match.data}{an optional data frame containing the matched sample}
}
\value{
a labeled vector.  For \code{sdiff}, the vector has six elements if
  \code{match.data} is provided: treated and control means and standardized
  differences before and after matching.  If \code{match.data} is not
  provided, the vector has only the three elements corresponding to the
  pre-match case.

  For the other functions, if \code{match.data} is provided, the vector
  contains p-values for the test before and after matching. Otherwise a
  single p-value is given for the pre-match data.
}
\description{
Balance assessment for individual variables, before and after matching
}
\details{
The \code{sdiff} function computes the standardized difference in means. The
other functions perform different kinds of balance tests: \code{t.balance}
does the 2-sample t-test, \code{fisher.balance} does Fisher's exact test for
binary variable, and \code{wilc.balance} does Wilcoxon's signed rank test.
}
\references{
Rosenbaum, Paul R. (2002). \emph{Observational Studies}.
  Springer-Verlag.

  Rosenbaum, Paul R. (2010). \emph{Design of Observational Studies}.
  Springer-Verlag.
}
\author{
Luke Keele, Penn State University, \email{ljk20@psu.edu}

  Sam Pimentel, University of Pennsylvania, \email{spi@wharton.upenn.edu}
}
\keyword{internal}
