% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchMulti-internal.R
\name{elastic}
\alias{elastic}
\alias{pairmatchelastic}
\title{Optimal Subset Matching without Balance Constraints}
\usage{
elastic(mdist, n = 0, val = 0)

pairmatchelastic(mdist, n = 0, val = 0)
}
\arguments{
\item{mdist}{distance matrix with rows corresponding to treated units and
columns corresponding to controls.}

\item{n}{maximum number of treated units that can be excluded.}

\item{val}{cost of excluding a treated unit (i.e. we prefer to exclude a
treated unit if it increases the total matched distance by more than
\code{val}).}
}
\value{
\code{elastic} returns an augmented version of the input matrix
  \code{mdist}.  \code{pairmatchelastic} returns a matrix of 1 column whose
  values are the column numbers of matched controls and whose rownames are
  the row numbers of matched treated units.
}
\description{
Conducts optimal subset matching as described in the reference.
}
\details{
\code{pairmatchelastic} is the main function, which conducts an entire match.
\code{elastic} is a helper function which augments the original distance
matrix as described in the reference. 

The original versions of these functions were written by Paul Rosenbaum and
distributed in the supplemental material to the paper: "Optimal Matching of
an Optimally Chosen Subset in Observational Studies," Paul R. Rosenbaum,
Journal of Computational and Graphical Statistics, Vol. 21, Iss. 1, 2012.
}
\references{
Rosenbaum, Paul R. (2012) "Optimal Matching of an Optimally
  Chosen Subset in Observational Studies."  Journal of Computational and
  Graphical Statistics, 21.1, 57-71.
}
\author{
Paul R. Rosenbaum (original forms), modifications by Luke Keele and
  Sam Pimentel
}
