% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuousMask.R
\name{continuousMask}
\alias{continuousMask}
\title{Update a binary raster (species range map) to continuous values that describe the proportion of cell that is suitable or the quality of the cell.}
\usage{
continuousMask(contStack, suitable, binaryRange, maskValue = NA, ...)
}
\arguments{
\item{contStack}{a stack of layers with continuous values.}

\item{suitable}{a vector of names of suitable layers of `contStack`. These can be substrings of the layer names that can be `grep`ped from `names(contStack)`}

\item{binaryRange}{a binary raster}

\item{maskValue}{numeric. The value in `binaryRange` that indicates the unsuitable cell}

\item{...}{arguments to be passed to `raster::mask`}
}
\value{
a raster
}
\description{
The use case envision is updating a binary map to continuous values that describe the proportion of the cell that is suitable, based on land  use/land cover classes
}
\details{
See Examples.
}
\author{
Cory Merow <cory.merow@gmail.com>,
}
