% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_functions.R
\name{get_log10bf}
\alias{get_log10bf}
\title{Return the Bayes Factor for each effect}
\usage{
get_log10bf(m)
}
\arguments{
\item{m}{the mash result (from joint or 1by1 analysis); must have
been computed using usepointmass=TRUE}
}
\value{
if m was fitted using usepointmass=TRUE then returns a
vector of the log10(bf) values for each effect. That is, the jth
element lbf[j] is log10(Pr(Bj | g=ghat-nonnull)/Pr(Bj | g = 0))
where ghat-nonnull is the non-null part of ghat.  Otherwise returns
NULL.
}
\description{
Return the Bayes Factor for each effect
}
\examples{
simdata = simple_sims(50,5,1)
data = mash_set_data(simdata$Bhat, simdata$Shat)
m = mash(data, cov_canonical(data))
get_log10bf(m)

}
