% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_my_file.R
\name{mark_my_file}
\alias{mark_my_file}
\title{Mark assignment file}
\usage{
mark_my_file(tasks = NULL, mark_file = file.choose(),
  assignment_path = NULL, force_get_tests = FALSE, quiet = FALSE,
  ...)
}
\arguments{
\item{tasks}{Which task should be corrected (if more than one). Default is all. 
To see the different task, see \code{\link{show_tasks}}.}

\item{mark_file}{Path to the file to mark.}

\item{assignment_path}{Assignment file to set before marking the assignment (url or local path).}

\item{force_get_tests}{Argument is deprecated, use \code{set_assignment()} instead.}

\item{quiet}{Should test be run without output?}

\item{...}{further arguments sent to \code{test_dir()}.}
}
\description{
Mark a specific assignment file
}
\examples{
\dontrun{
assignment_path <- 
  file.path(system.file(package = "markmyassignment"), "extdata", "example_assignment01.yml")
file_path <- file.path(system.file(package = "markmyassignment"), "extdata", "example_lab_file.R")
mark_my_file(mark_file = file_path, assignment_path = assignment_path)
}
}
