% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PerformanceForecast.R
\name{PerformanceForecast}
\alias{PerformanceForecast}
\title{A prediction of your website performance using auto-ARIMA model}
\usage{
PerformanceForecast(start.date, end.date, metrics, table.id, export = FALSE)
}
\arguments{
\item{start.date}{Start date for fetching Analytics data. Requests can
specify a start date formatted as YYYY-MM-DD, or as a relative date
(e.g., today, yesterday, or NdaysAgo where N is a positive integer).}

\item{end.date}{End date for fetching Analytics data. Request can specify
an end date formatted as YYYY-MM-DD, or as a relative date (e.g., today,
yesterday, or NdaysAgo where N is a positive integer).}

\item{metrics}{A list of comma-separated metrics, such as \code{ga:metrics}.}

\item{table.id}{The unique table ID of the form ga:XXXX, where XXXX is the
Analytics view (profile) ID for which the query will retrieve the data.}

\item{export}{If the export option is set as "TRUE", both raw data &
graphics will be exported in the current working directory. Otherwise,
R will only print raw data and display a visualization of the forecast.}
}
\description{
\code{PerformanceForecast} is a quick way to predict how your
  website will perform in the next 12 months based on your past scores.
}
\note{
The black part is the past website traffic data; the blue part is the
  graphical representation of the forecast, with Lo 80/Lo 95 & Hi 80/Hi 95.
}
\examples{
\dontrun{
  PerformanceForecast(start.date = "2007-02-01", end.date ="2015-06-30",
  metrics = "ga:sessions", table.id = "ga:XXXXXXX", export = FALSE)}
}

