% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match-arg.R
\name{match_param}
\alias{match_param}
\title{Match params}
\usage{
match_param(param, choices, null = TRUE)
}
\arguments{
\item{param}{The parameter}

\item{choices}{The available choices; named lists will return the name (a
character) for when matched to the value within the list element}

\item{null}{If \code{TRUE} allows \code{NULL} to be passed a \code{param}}
}
\value{
A single value from \code{param} matched on \code{choices}
}
\description{
Much like \code{\link[base:match.arg]{base::match.arg()}} with a few key differences:
\itemize{
\item Will not perform partial matching
\item Will not return error messages with ugly quotation marks
}
}
\details{
Param matching for an argument
}
\examples{
fruits <- function(x = c("apple", "banana", "orange")) {
  match_param(x)
}

fruits()         # apple
try(fruits("b")) # must be exact fruits("banana")

# can have multiple responses
how_much <- function(x = list(too_few = 0:2, ok = 3:5, too_many = 6:10)) {
  match_param(x)
}

how_much(1)
how_much(3)
how_much(9)
}
\seealso{
\code{\link[=match_arg]{match_arg()}}
}
