% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/largeFishIndicator.R
\name{largeFishIndicator}
\alias{largeFishIndicator}
\title{Calculates the Large Fish Indicator}
\usage{
largeFishIndicator(X_length, group, species.table = NULL,
  metric = "BIOMASS", large.fish = 35, years)
}
\arguments{
\item{X_length}{A dataframe of fishery independent data derived from research
vessel survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, \code{LENGTH}, and \code{BIOMASS}. \code{YEAR} indicates the
year the observation was recorded, \code{ID} is an area code indicating
where the observation was recorded, and \code{SPECIES} is a numeric code
indicating the species sampled. \code{LENGTH} is the length class (cm) and
\code{BIOMASS} is the corresponding abundance at length (stratified and
corrected for catchability as required). Species for which there are no
length data should be assigned \code{LENGTH = -99}. These observations are
removed by the function.}

\item{group}{character string indicating which species to include in the
indicator calculation. If \code{group = "ALL"}, all species will be
included; otherwise, \code{group} should match a column name in
\code{species.table}.}

\item{species.table}{A table where the column names match the entries in
\code{groups}. Column entries are species codes indicating the species from
\code{X} included in each group. \code{species.table} may also include
columns for other species groups; these will be ignored. If \code{groups =
"ALL"}, this table is not required. Default is \code{species.table = NULL}.}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate indicator. Default is \code{metric = "BIOMASS"}.}

\item{large.fish}{Threshold for large fish (cm). Default is \code{large.fish =
35} (i.e., large fish are those with \code{X_length$LENGTH} >= 35 cm).}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with 3 columns. \code{ID}, \code{YEAR}, and
 \code{LargeFishIndicator}.

 If there are no observations of large fish or no observations in \code{X}
 for spatial scale \eqn{j} in year \eqn{i}, indicator value is assigned
 \code{NA}.
}
\description{
This function calculates the Large Fish Indicator (LFI) for
 \eqn{j} areas and \eqn{i} years.
}
\details{
Large Fish Indicator (LFI): \deqn{LFI = \Sigma B_m(L >35 cm)/\Sigma
 B_m} \eqn{B_m} is biomass of individuals in a body size class centered at
 mass m, and \eqn{L} is the length (cm) of an individual. This indicator
 describes the proportion (by weight) of the fish community that is larger
 than some length threshold (default here is 35 cm, i.e., the proportion of
 biomass occupying the top predator trophic level; Greenstreet and Rogers,
 2006).
}
\examples{
# Compile data
data(X_length)
data(species.table)

# Calculate indicator
largeFishIndicator(X_length, group = "FINFISH", species.table = species.table,
   metric = "BIOMASS", years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Greenstreet SPR and Rogers SI. 2006. Indicators of the health of the fish
 community of the North Sea: identifying reference levels for an Ecosystem
 Approach to Management. ICES J. Mar. Sci., 63: 573–593.

 ICES. 2006. Report of the Working Group on Ecosystem Effects of Fishing
 Activities. ICES Document CM 2006/ACE: 05. 174 pp.
}
\seealso{
Other ecosystem structure and function indicators: \code{\link{allStructure}},
  \code{\link{biomassRatio}},
  \code{\link{communityCondition}},
  \code{\link{largeSpeciesIndicator}},
  \code{\link{meanTLCommunity}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{ecosystem structure and function indicators}
