% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/march.dataset.R
\name{march.dataset.loadFromDataFrame}
\alias{march.dataset.loadFromDataFrame}
\title{Construct a dataset from a data.frame or a matrix.}
\usage{
march.dataset.loadFromDataFrame(dataframe, MARGIN = 2, weights = NA,
  missingDataRep = NA)
}
\arguments{
\item{dataframe}{A \code{\link{data.frame}} containing the dataset.}

\item{MARGIN}{The dimension of the matrix/data.frame that contains the sequences (resp 1 for the column, 2 for the rows).}

\item{weights}{If specified, contains the weight of each sequence.}

\item{missingDataRep}{If specified, the symbol representing a missing data.}
}
\value{
A \code{\link[=march.Dataset-class]{march.Dataset}} object containing the data contructed from the matrix or data.frame.
}
\description{
The function creates a \code{\link[=march.Dataset-class]{march.Dataset}} from a \emph{dataframe} or a \emph{matrix}, where each row (resp. column) represents 
an independent data series when \emph{MARGIN} is 2 (resp. 1).
}
\examples{
# Create a march dataset from the sleep_df dataframe included in the march package.
sleep <- march.dataset.loadFromDataFrame(sleep_df, MARGIN = 2,
                            weights = NA, missingDataRep = NA)

# Each row of sleep_df contains the data for one subject, so MARGIN was set to 2.

# Most of the subjects have been observed during 7 consecutive years,
# but some subjects have been observed for only 5 or 6 years.
# To load only the first 5 observations of each subject:
sleep.5 <- march.dataset.loadFromDataFrame(sleep_df[,1:5], MARGIN = 2 ,
                            weights = NA, missingDataRep = NA)

# The sleep data are not weighted.
# To add a weighting variable taking value 1.5 for the 500 first subjects
# and value 0.5 for the 500 next:
weighting <- rep(1.5,1000)
weighting[501:1000] <- rep(0.5,500)
sleep.w <- march.dataset.loadFromDataFrame(sleep_df, MARGIN = 2,
                           weights = weighting, missingDataRep = NA)
}
\author{
Ogier Maitre
}

