% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popupTable.R
\name{popupTable}
\alias{popupTable}
\title{Create HTML strings for popup tables}
\usage{
popupTable(x, zcol, use_cpp = TRUE)
}
\arguments{
\item{x}{A \code{Spatial*} object.}

\item{zcol}{\code{numeric} or \code{character} vector indicating the columns
included in the output popup table. If missing, all columns are displayed.}

\item{use_cpp}{\code{logical} determining whether or not to enable
\strong{Rcpp} functionality.}
}
\value{
A \code{list} of HTML strings required to create feature popup table(s).
}
\description{
Create HTML strings for \code{popup} tables used as input for
\code{\link{mapview}}. This optionally allows the user to include only a
subset of feature attributes.
}
\examples{
\dontrun{
library(sp)

data(meuse)
coordinates(meuse) <- ~ x + y
proj4string(meuse) <- CRS("+init=epsg:28992")

## include columns 1 and 2 only
mapview(meuse, popup = popupTable(meuse, zcol = 1:2))
}

}
\seealso{
\code{\link{popupGraph}} and \code{\link{popupImage}}.
}

