% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mf_symb_choro.R
\name{mf_symb_choro}
\alias{mf_symb_choro}
\title{Plot symbols using choropleth coloration}
\usage{
mf_symb_choro(
  x,
  var,
  pal = "Mint",
  alpha = 1,
  rev = FALSE,
  breaks = "quantile",
  nbreaks,
  border = getOption("mapsf.fg"),
  pch,
  cex = 1,
  lwd = 0.7,
  pch_na = 4,
  cex_na = 1,
  col_na = "white",
  val_order,
  leg_pos = mf_get_leg_pos(x, 1),
  leg_title = var,
  leg_title_cex = c(0.8, 0.8),
  leg_val_cex = c(0.6, 0.6),
  leg_val_rnd = 2,
  leg_no_data = c("No data", "No data"),
  leg_frame = c(FALSE, FALSE),
  leg_frame_border = getOption("mapsf.fg"),
  leg_horiz = FALSE,
  leg_adj = c(0, 0),
  leg_fg = getOption("mapsf.fg"),
  leg_bg = getOption("mapsf.bg"),
  leg_size = 1,
  leg_box_border = getOption("mapsf.fg"),
  leg_box_cex = c(1, 1),
  add = TRUE
)
}
\arguments{
\item{x}{object of class \code{sf}}

\item{var}{name(s) of the variable(s) to plot}

\item{pal}{a set of colors or a palette name (from \link{hcl.colors})}

\item{alpha}{if \code{pal} is a \link{hcl.colors} palette name, the alpha-transparency level in the range [0,1]}

\item{rev}{if \code{pal} is a \link{hcl.colors} palette name, whether the ordering of the colors should be reversed (TRUE) or not (FALSE)}

\item{breaks}{either a numeric vector with the actual breaks, or a classification method name (see \link{mf_get_breaks} and Details)}

\item{nbreaks}{number of classes}

\item{border}{border color}

\item{pch}{pch (point type) for symbols}

\item{cex}{cex (point size) for symbols}

\item{lwd}{border width}

\item{pch_na}{pch (point type) for NA values}

\item{cex_na}{cex (point size) for NA values}

\item{col_na}{color for missing values}

\item{val_order}{values order, a character vector that matches var modalities}

\item{leg_pos}{position of the legend, two of 'topleft', 'top','topright', 'right','bottomright', 'bottom', 'bottomleft', 'left' or a vector of two coordinates in map units (c(x, y)). leg_pos argument can be c('position', 'position'), c('position', x2, y2), c(x1,y1, 'position') or c(x1, y1, x2, y2). Use NA to avoid plotting the legend, use 'interactive' to choose thelegend position interactively.}

\item{leg_title}{legend title}

\item{leg_title_cex}{size of the legend title}

\item{leg_val_cex}{size of the values in the legend}

\item{leg_val_rnd}{number of decimal places of the values in the legend}

\item{leg_no_data}{label for missing values}

\item{leg_frame}{whether to add a frame to the legend (TRUE) or not (FALSE)}

\item{leg_frame_border}{border color of the legend frame}

\item{leg_horiz}{display the legend horizontally (for proportional symbols and choropleth types)}

\item{leg_adj}{adjust the postion of the legend in x and y directions}

\item{leg_fg}{color of the legend foreground}

\item{leg_bg}{color of the legend backgournd}

\item{leg_size}{size of the legend; 2 means two times bigger}

\item{leg_box_border}{border color of legend boxes}

\item{leg_box_cex}{width and height size expansion of boxes}

\item{add}{whether to add the layer to an existing plot (TRUE) or not (FALSE)}
}
\value{
x is (invisibly) returned.
}
\description{
Plot symbols with colors based on a quantitative
data classification.
}
\details{
Breaks defined by a numeric vector or a classification method are
left-closed: breaks defined by \code{c(2, 5, 10, 15, 20)}
will be mapped as [2 - 5[, [5 - 10[, [10 - 15[, [15 - 20].
The "jenks" method is an exception and has to be right-closed.
Jenks breaks computed as \code{c(2, 5, 10, 15, 20)}
will be mapped as [2 - 5], ]5 - 10], ]10 - 15], ]15 - 20].
}
\examples{
mtq <- mf_get_mtq()
mf_map(mtq)
mf_symb_choro(mtq, c("STATUS", "MED"))

mf_map(mtq)
mtq$STATUS[30] <- NA
mtq$MED[5] <- NA
mf_symb_choro(mtq, c("STATUS", "MED"),
  pal = "Reds 3", breaks = "quantile", nbreaks = 4,
  pch = 21:23, cex = c(3, 2, 1),
  pch_na = 25, cex_na = 1.5, col_na = "blue",
  val_order = c(
    "Prefecture",
    "Sub-prefecture",
    "Simple municipality"
  )
)
}
\keyword{internal}
