% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_matrix.R
\name{extract_matrix}
\alias{extract_matrix}
\title{Extract distance or duration *matrix* from a Google Maps Distance Matrix API response}
\usage{
extract_matrix(doc, value = "distance_m")
}
\arguments{
\item{doc}{XML document with Google Maps Distance Matrix API response}

\item{value}{Value to extract, one of: \code{"distance_m"} (default), \code{"distance_text"}, \code{"duration_s"}, \code{"duration_text"}}
}
\value{
\code{matrix}
}
\description{
Extract distance or duration *matrix* from a Google Maps Distance Matrix API response
}
\examples{
library(xml2)
doc = as_xml_document(response_matrix)
extract_matrix(doc, value = "distance_m")
extract_matrix(doc, value = "distance_text")
extract_matrix(doc, value = "duration_s")
extract_matrix(doc, value = "duration_text")
\dontrun{
locations = c("Haifa", "Tel-Aviv", "Jerusalem", "Beer-Sheva")
doc = google_matrix(
  origins = locations,
  destinations = locations
)
extract_matrix(doc, value = "distance_m")
extract_matrix(doc, value = "distance_text")
extract_matrix(doc, value = "duration_s")
extract_matrix(doc, value = "duration_text")
}
}
