% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maple_viz.R
\name{maple_viz}
\alias{maple_viz}
\title{Plot tissue architecture labels}
\usage{
maple_viz(
  fit,
  pt.size = 1,
  interactive = FALSE,
  shade_uncertainty = FALSE,
  feature = NULL
)
}
\arguments{
\item{fit}{A list returned by fit_maple()}

\item{pt.size}{The size of each cell spot point}

\item{interactive}{Logical parameter controlling static or interactive nature of plot}

\item{shade_uncertainty}{Logical parameter for shading of cell spots by posterior uncertainty. Must run get_maple_scores() first.}

\item{feature}{A user-provided feature (e.g., gene of interest) to visualize over tissue spaces instead of sub-population labels.}
}
\value{
A ggplot object or shiny app window
}
\description{
This function allows you to plot (static or interactive) cell spot labels and uncertainty measures
}
\examples{
\dontrun{
brain1 <- LoadData("stxBrain", type = "anterior1")
brain2 <- LoadData("stxBrain", type = "anterior2")
brain1 <- SCTransform(brain1, assay = "Spatial", verbose = FALSE)
brain2 <- SCTransform(brain2, assay = "Spatial", verbose = FALSE)
brain <- merge(brain1,brain2)
DefaultAssay(brain) <- "SCT"
VariableFeatures(brain) <- c(VariableFeatures(brain1),VariableFeatures(brain2))
brain <- RunPCA(brain)
brain_fit_PCs <- fit_maple(brain,K = 6,emb = "PCs")
maple_viz(brain_fit_PCs)
}
}
\keyword{Bayesian}
\keyword{spatial}
\keyword{transcriptomics}
