% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indirect_proportion.R
\name{indirect_proportion}
\alias{indirect_proportion}
\title{Proportion of Effect Mediated}
\usage{
indirect_proportion(x, y, m = NULL, fit = NULL)
}
\arguments{
\item{x}{The name of the \code{x} variable.
Must be supplied as a quoted string.}

\item{y}{The name of the \code{y} variable.
Must be supplied as a quoted string.}

\item{m}{A vector of the variable
names of the mediator(s). The path
goes from the first mediator
successively to the last mediator.
Cannot be \code{NULL} for this function.}

\item{fit}{The fit object. Can be a
\link[lavaan:lavaan-class]{lavaan::lavaan} object or a
list of \code{\link[=lm]{lm()}} outputs.
It can also be
a \code{lavaan.mi} object
returned by
\code{\link[lavaan.mi:lavaan.mi]{lavaan.mi::lavaan.mi()}} or
its wrapper, such as \code{\link[lavaan.mi:lavaan.mi]{lavaan.mi::sem.mi()}}.}
}
\value{
An \code{indirect_proportion} class object.
It is a list-like object with these
major elements:
\itemize{
\item \code{proportion}: The proportion of
effect mediated.
\item \code{x}: The name of the \code{x}-variable.
\item \code{y}: The name of the \code{y}-variable.
\item \code{m}: A character vector of the
mediator(s) along a path. The path
runs from the first element to the
last element.
}

This class has a \code{print} method
and a \code{coef} method.
}
\description{
It computes the proportion
of effect mediated along a pathway.
}
\details{
The proportion of effect
mediated along a path from \code{x} to
\code{y} is the indirect effect along
this path divided by the total
effect from \code{x} to \code{y}
(Alwin & Hauser, 1975). This total
effect is equal to the sum of all
indirect effects from \code{x} to \code{y}
and the direct effect from \code{x} to
\code{y}.

To ensure that the proportion can
indeed be interpreted as a proportion,
this function computes the the
proportion only if the signs of
all the indirect and direct effects
from \code{x} to \code{y}
are same (i.e., all effects
positive or all effects negative).
}
\examples{

library(lavaan)
dat <- data_med
head(dat)
mod <-
"
m ~ x + c1 + c2
y ~ m + x + c1 + c2
"
fit <- sem(mod, dat, fixed.x = FALSE)
out <- indirect_proportion(x = "x",
                           y = "y",
                           m = "m",
                           fit = fit)
out

}
\references{
Alwin, D. F., & Hauser, R. M. (1975).
The decomposition of effects in path
analysis.
\emph{American Sociological Review, 40}(1),
37. \doi{10.2307/2094445}
}
\seealso{
\code{\link[=print.indirect_proportion]{print.indirect_proportion()}}
for the \code{print} method, and
\code{\link[=coef.indirect_proportion]{coef.indirect_proportion()}} for
the \code{coef} method.
}
