% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_med_mod_a}
\alias{data_med_mod_a}
\title{Sample Dataset: Simple
Mediation with a-Path Moderated}
\format{
A data frame with 100 rows
and 6 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{w}{Moderator. Numeric.}
\item{m}{Mediator. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_med_mod_a
}
\description{
A simple mediation model
with a-path moderated.
}
\examples{
library(lavaan)
data(data_med_mod_a)
data_med_mod_a$xw <-
 data_med_mod_a$x *
 data_med_mod_a$w
mod <-
"
m ~ a * x + w + d * xw + c1 + c2
y ~ b * m + x + w + c1 + c2
w ~~ v_w * w
w ~ m_w * 1
ab := a * b
ab_lo := (a + d * (m_w - sqrt(v_w))) * b
ab_hi := (a + d * (m_w + sqrt(v_w))) * b
"
fit <- sem(mod, data_med_mod_a,
           meanstructure = TRUE, fixed.x = FALSE)
parameterEstimates(fit)[c(1, 3, 6, 11, 12, 31:33), ]
}
\keyword{datasets}
