% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treaties_get.R
\name{get_treaty}
\alias{get_treaty}
\alias{get_bilaterals}
\alias{get_multilaterals}
\title{Get international treaties}
\usage{
get_bilaterals(membs)

get_multilaterals(membs)
}
\arguments{
\item{membs}{A memberships dataset from one of the many packages}
}
\value{
A tibble of bilateral agreements

A tibble of multilateral agreements
}
\description{
Some datasets in the membership databases across the
'many* packages' (e.g. manyenviron) contain a myriad of information on
international treaties governing an international domain.
The get treaty functions help researchers retrieve all bilateral
agreements, or multilateral agreements, from these datasets.
Researchers can, for example, use \code{get_bilaterals()} to retrieve
which countries have signed a specific international agreement, or
several international agreements signed in a respective year.
As well, researchers can use \code{get_multilaterals()} to retrieve
the titles of all multilateral agreements signed in the past 10 years,
for instance.
Alternatively, to get information from several datasets in a
memberships database, researchers can \code{consolidate()} the database
into one dataset with some combination of the rows, columns,
and observations of the datasets before getting the desired
bilateral or multilateral treaties.
}
\examples{
membs <- tibble::tibble(CountryID = c("ROU", "RUS", "DNK"),
manyID = c("ROU-RUS[RFP]_1901A", "ROU-RUS[RFP]_1901A", "GD16FI_1901A"),
Title = c("Convention Between Roumania And Russia Concerning Fishing
In The Danube And The Pruth",
"Convention Between Roumania And Russia Concerning Fishing
In The Danube And The Pruth",
"Convention Between The Governments Of Denmark And
The United Kingdom Of Great Britain
And Northern Ireland For Regulating The Fisheries
Of Their Respective Subjects Outside
Territorial Waters In The Ocean Surrounding The Faroe Islands"),
Beg = c("1901-02-22", "1901-02-22", "1901-06-24"),
End = c(NA, NA, NA))
get_bilaterals(membs)
membs <- tibble::tibble(CountryID = c("ROU", "RUS", "DNK"),
manyID = c("ROU-RUS[RFP]_1901A", "ROU-RUS[RFP]_1901A", "GD16FI_1901A"),
Title = c("Convention Between Roumania And Russia Concerning Fishing
In The Danube And The Pruth",
"Convention Between Roumania And Russia Concerning Fishing
In The Danube And The Pruth",
"Convention Between The Governments Of Denmark And
The United Kingdom Of Great Britain
And Northern Ireland For Regulating The Fisheries
Of Their Respective Subjects Outside
Territorial Waters In The Ocean Surrounding The Faroe Islands"),
Beg = c("1901-02-22", "1901-02-22", "1901-06-24"),
End = c(NA, NA, NA))
get_multilaterals(membs)
}
