/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.RankedFeatureVector;
import gnu.trove.TIntIntHashMap;

public class FeatureCounter {
    Alphabet alphabet;
    TIntIntHashMap featureCounts;

    public FeatureCounter(Alphabet alphabet) {
        this.alphabet = alphabet;
        this.featureCounts = new TIntIntHashMap();
    }

    public int increment(Object entry) {
        return this.featureCounts.adjustOrPutValue(this.alphabet.lookupIndex(entry), 1, 1);
    }

    public int increment(Object entry, int incr) {
        return this.featureCounts.adjustOrPutValue(this.alphabet.lookupIndex(entry), incr, incr);
    }

    public int increment(int featureIndex) {
        if (featureIndex < 0 || featureIndex > this.alphabet.size()) {
            throw new IllegalArgumentException("featureIndex " + featureIndex + " out of range");
        }
        return this.featureCounts.adjustOrPutValue(featureIndex, 1, 1);
    }

    public int increment(int featureIndex, int incr) {
        if (featureIndex < 0 || featureIndex > this.alphabet.size()) {
            throw new IllegalArgumentException("featureIndex " + featureIndex + " out of range");
        }
        return this.featureCounts.adjustOrPutValue(featureIndex, incr, incr);
    }

    public int get(int featureIndex) {
        if (featureIndex < 0 || featureIndex > this.alphabet.size()) {
            throw new IllegalArgumentException("featureIndex " + featureIndex + " out of range");
        }
        return this.featureCounts.get(featureIndex);
    }

    public int get(Object entry) {
        int fi = this.alphabet.lookupIndex(entry, false);
        if (fi == -1) {
            return 0;
        }
        return this.featureCounts.get(fi);
    }

    public int put(int featureIndex, int value) {
        if (featureIndex < 0 || featureIndex > this.alphabet.size()) {
            throw new IllegalArgumentException("featureIndex " + featureIndex + " out of range");
        }
        return this.featureCounts.put(featureIndex, value);
    }

    public int put(Object entry, int value) {
        return this.featureCounts.put(this.alphabet.lookupIndex(entry), value);
    }

    public FeatureVector toFeatureVector() {
        int[] indices = this.featureCounts.keys();
        double[] values = new double[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            values[i] = this.featureCounts.get(indices[i]);
        }
        return new FeatureVector(this.alphabet, indices, values);
    }

    public RankedFeatureVector toRankedFeatureVector() {
        int[] indices = this.featureCounts.keys();
        double[] values = new double[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            values[i] = this.featureCounts.get(indices[i]);
        }
        return new RankedFeatureVector(this.alphabet, indices, values);
    }
}

