/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AugmentableFeatureVector;
import cc.mallet.types.FeatureVector;
import gnu.trove.TIntObjectHashMap;
import java.io.Serializable;

public class Record
implements Serializable {
    private static final long serialVersionUID = 1L;
    Alphabet fieldAlph;
    Alphabet valueAlph;
    TIntObjectHashMap<FeatureVector> field2values;

    public Record(Alphabet fieldAlph, Alphabet valueAlph) {
        this.fieldAlph = fieldAlph;
        this.valueAlph = valueAlph;
        this.field2values = new TIntObjectHashMap();
    }

    public Record(Alphabet fieldAlph, Alphabet valueAlph, String[][] vals) {
        this(fieldAlph, valueAlph);
        for (int i = 0; i < vals.length; ++i) {
            AugmentableFeatureVector afv = new AugmentableFeatureVector(valueAlph, false);
            for (int j = 1; j < vals[i].length; ++j) {
                afv.add(valueAlph.lookupIndex(vals[i][j]), 1.0);
            }
            this.field2values.put(fieldAlph.lookupIndex(vals[i][0]), (Object)afv.toFeatureVector());
        }
    }

    public FeatureVector values(String field) {
        return this.values(this.fieldAlph.lookupIndex(field));
    }

    public FeatureVector values(int field) {
        return (FeatureVector)this.field2values.get(field);
    }

    public int value(String field) {
        return this.value(this.fieldAlph.lookupIndex(field));
    }

    public int value(int field) {
        FeatureVector fv = this.values(field);
        return fv == null ? -1 : fv.indexAtLocation(0);
    }

    public int[] fields() {
        return this.field2values.keys();
    }

    public Alphabet fieldAlphabet() {
        return this.fieldAlph;
    }

    public Alphabet valueAlphabet() {
        return this.valueAlph;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean oneLine) {
        StringBuffer b = new StringBuffer();
        int[] keys = this.field2values.keys();
        for (int i = 0; i < keys.length; ++i) {
            b.append(this.fieldAlph.lookupObject(keys[i]) + "=");
            FeatureVector v = (FeatureVector)this.field2values.get(keys[i]);
            for (int j = 0; j < v.numLocations(); ++j) {
                b.append(this.valueAlph.lookupObject(v.indexAtLocation(j)) + ",");
            }
            if (oneLine) continue;
            b.append("\n");
        }
        return b.toString();
    }

    public static void main(String[] args) {
        Record r = new Record(new Alphabet(), new Alphabet(), new String[][]{{"field1", "f1v1", "f1v2"}, {"field2", "f2v1"}, {"field3", "f3v1", "f3v2", "f3v3"}});
        System.out.println(r);
    }
}

