% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/MapSchedule.R, R/generate.R
\docType{methods}
\name{generate}
\alias{generate}
\alias{generate,MapSchedule-method}
\alias{generate,TaskSchedule-method}
\title{Generate Code From A Schedule}
\usage{
generate(schedule, ...)

\S4method{generate}{MapSchedule}(schedule, ...)

\S4method{generate}{TaskSchedule}(schedule, portStart = 33000L,
  minTimeout = 600)
}
\arguments{
\item{schedule}{object inheriting from class \linkS4class{Schedule}}

\item{...}{additional arguments to methods}

\item{portStart}{first local port to use, can possibly use up to n * (n -
1) / 2 subsequent ports if every pair of n workers must communicate.}

\item{minTimeout}{timeout for socket connection will be at least this
many seconds.}
}
\value{
x object of class \linkS4class{GeneratedCode}
}
\description{
Generate Code From A Schedule

Produces executable code that relies on a SNOW cluster on a single
machine and sockets.
}
\seealso{
\code{\link{schedule}} generic function to create
\linkS4class{Schedule}, \code{\link{writeCode}} to write and extract the
actual code, and
\code{\link{makeParallel}} to do everything all at once.
}
