% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transform}
\alias{transform}
\alias{image_trim}
\alias{image_chop}
\alias{image_rotate}
\alias{image_resize}
\alias{image_scale}
\alias{image_sample}
\alias{image_crop}
\alias{image_flip}
\alias{image_flop}
\alias{image_deskew}
\alias{image_page}
\alias{image_repage}
\alias{image_orient}
\title{Image Transform}
\usage{
image_trim(image, fuzz = 0)

image_chop(image, geometry)

image_rotate(image, degrees)

image_resize(image, geometry = NULL, filter = NULL)

image_scale(image, geometry = NULL)

image_sample(image, geometry = NULL)

image_crop(image, geometry = NULL, repage = TRUE)

image_flip(image)

image_flop(image)

image_deskew(image, threshold = 40)

image_page(image, pagesize = NULL, density = NULL)

image_repage(image)

image_orient(image, orientation = NULL)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{fuzz}{Fuzz percentage: value between 0 and 100. Relative distance between
colors to be considered similar in the filling algorithm.}

\item{geometry}{a \link{geometry} string specifying area (for cropping) or size (for resizing).}

\item{degrees}{value between 0 and 360 for how many degrees to rotate}

\item{filter}{string with \href{https://www.imagemagick.org/Magick++/Enumerations.html#FilterTypes}{filter}
type from: \link{filter_types}}

\item{repage}{resize the canvas to the cropped area}

\item{threshold}{straightens an image. A threshold of 40 works for most images.}

\item{pagesize}{geometry string with preferred size and location of an image canvas}

\item{density}{geometry string with vertical and horizontal resolution in pixels of
the image. Specifies an image density when decoding a Postscript or PDF.}

\item{orientation}{string to set image orientation one of the \link{orientation_types}.
If \code{NULL} it applies auto-orientation which tries to infer the correct orientation
from the Exif data.}
}
\description{
Basic transformations like rotate, resize, crop and flip. The \link{geometry} syntax
is used to specify sizes and areas.
}
\details{
For details see \href{https://www.imagemagick.org/Magick++/STL.html}{Magick++ STL}
documentation. Short descriptions:
\itemize{
\item \link{image_trim} removes edges that are the background color from the image.
\item \link{image_chop} removes vertical or horizontal subregion of image.
\item \link{image_crop} cuts out a subregion of original image
\item \link{image_rotate} rotates and increases size of canvas to fit rotated image.
\item \link{image_deskew} auto rotate to correct skewed images
\item \link{image_resize} resizes using custom \href{https://www.imagemagick.org/Magick++/Enumerations.html#FilterTypes}{filterType}
\item \link{image_scale} and \link{image_sample} resize using simple ratio and pixel sampling algorithm.
\item \link{image_flip} and \link{image_flop} invert image vertically and horizontally
}

The most powerful resize function is \link{image_resize} which allows for setting
a custom resize filter. Output of \link{image_scale} is similar to \code{image_resize(img, filter = "point")}.

For resize operations it holds that if no \code{geometry} is specified, all frames
are rescaled to match the top frame.
}
\examples{
logo <- image_read("logo:")
logo <- image_scale(logo, "400")
image_trim(logo)
image_chop(logo, "100x20")
image_rotate(logo, 45)
# Small image
rose <- image_convert(image_read("rose:"), "png")

# Resize to 400 width or height:
image_resize(rose, "400x")
image_resize(rose, "x400")

# Resize keeping ratio
image_resize(rose, "400x400")

# Resize, force size losing ratio
image_resize(rose, "400x400!")

# Different filters
image_resize(rose, "400x", filter = "Triangle")
image_resize(rose, "400x", filter = "Point")
# simple pixel resize
image_scale(rose, "400x")
image_sample(rose, "400x")
image_crop(logo, "400x400+200+200")
image_flip(logo)
image_flop(logo)
if(magick_config()$version > "6.8.6")
  image_orient(logo)
}
\seealso{
Other image: \code{\link{_index_}}, \code{\link{analysis}},
  \code{\link{animation}}, \code{\link{attributes}},
  \code{\link{color}}, \code{\link{composite}},
  \code{\link{device}}, \code{\link{edges}},
  \code{\link{editing}}, \code{\link{effects}},
  \code{\link{fx}}, \code{\link{geometry}},
  \code{\link{morphology}}, \code{\link{ocr}},
  \code{\link{options}}, \code{\link{painting}},
  \code{\link{segmentation}}, \code{\link{video}}
}
\concept{image}
