% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transform}
\alias{transform}
\alias{image_trim}
\alias{image_chop}
\alias{image_rotate}
\alias{image_resize}
\alias{image_scale}
\alias{image_sample}
\alias{image_crop}
\alias{image_flip}
\alias{image_flop}
\alias{image_deskew}
\alias{image_page}
\title{Image Transform}
\usage{
image_trim(image)

image_chop(image, geometry)

image_rotate(image, degrees)

image_resize(image, geometry = NULL, filter = NULL)

image_scale(image, geometry = NULL)

image_sample(image, geometry = NULL)

image_crop(image, geometry = NULL)

image_flip(image)

image_flop(image)

image_deskew(image, threshold = 40)

image_page(image, pagesize = NULL, density = NULL)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{geometry}{a string with \href{https://www.imagemagick.org/Magick++/Geometry.html}{geometry syntax}
specifying width+height and/or position offset. See details and examples below.}

\item{degrees}{value between 0 and 360 for how many degrees to rotate}

\item{filter}{string with a \href{https://www.imagemagick.org/Magick++/Enumerations.html#FilterTypes}{filtertype}.}

\item{threshold}{straightens an image. A threshold of 40 works for most images.}

\item{pagesize}{geometry string with preferred size and location of an image canvas}

\item{density}{geometry string with vertical and horizontal resolution in pixels of
the image. Specifies an image density when decoding a Postscript or PDF.}
}
\description{
Basic transformations like rotate, resize, crop and flip. Details below.
}
\details{
For details see \href{https://www.imagemagick.org/Magick++/STL.html}{Magick++ STL}
documentation. Short descriptions:
\itemize{
\item \link{image_trim} removes edges that are the background color from the image.
\item \link{image_chop} removes vertical or horizontal subregion of image.
\item \link{image_crop} cuts out a subregion of original image
\item \link{image_rotate} rotates and increases size of canvas to fit rotated image.
\item \link{image_deskew} auto rotate to correct skewed images
\item \link{image_resize} resizes using custom \href{https://www.imagemagick.org/Magick++/Enumerations.html#FilterTypes}{filterType}
\item \link{image_scale} and \link{image_sample} resize using simple ratio and pixel sampling algorithm.
\item \link{image_flip} and \link{image_flop} invert image vertically and horizontally
}

The most powerful resize function is \link{image_resize} which allows for setting
a custom resize filter. Output of \link{image_scale} is similar to \code{image_resize(img, filter = "point")}.

For resize operations it holds that if no \code{geometry} is specified, all frames
are rescaled to match the top frame.
Examples of \code{geometry} strings:
\itemize{
\item \strong{\code{"500x300"}}       -- \emph{Resize image keeping aspect ratio, such that width does not exceed 500 and the height does not exceed 300.}
\item \strong{\code{"500x300!"}}      -- \emph{Resize image to 500 by 300, ignoring aspect ratio}
\item \strong{\code{"500x"}}          -- \emph{Resize width to 500 keep aspect ratio}
\item \strong{\code{"x300"}}          -- \emph{Resize height to 300 keep aspect ratio}
\item \strong{\code{"50\%x20\%"}} -- \emph{Resize width to 50 percent and height to 20 percent of original}
\item \strong{\code{"500x300+10+20"}} -- \emph{Crop image to 500 by 300 at position 10,20}
}
}
\examples{
logo <- image_read("logo:")
logo <- image_scale(logo, "400")
image_trim(logo)
image_chop(logo, "100x20")
image_rotate(logo, 45)
# Small image
rose <- image_convert(image_read("rose:"), "png")

# Resize to 400 width or height:
image_resize(rose, "400x")
image_resize(rose, "x400")

# Resize keeping ratio
image_resize(rose, "400x400")

# Resize, force size losing ratio
image_resize(rose, "400x400!")

# Different filters
image_resize(rose, "400x", filter = "Triangle")
image_resize(rose, "400x", filter = "Point")
# simple pixel resize
image_scale(rose, "400x")
image_sample(rose, "400x")
image_crop(logo, "400x400+200+200")
image_flip(logo)
image_flop(logo)
}
\seealso{
Other image: \code{\link{_index_}}, \code{\link{analysis}},
  \code{\link{animation}}, \code{\link{attributes}},
  \code{\link{color}}, \code{\link{composite}},
  \code{\link{device}}, \code{\link{editing}},
  \code{\link{effects}}, \code{\link{ocr}},
  \code{\link{painting}}
}
