% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaestroPipeline.R
\name{MaestroPipeline}
\alias{MaestroPipeline}
\title{Class for an individual maestro pipeline
A pipeline is defined as a single R script with a schedule or input}
\description{
Class for an individual maestro pipeline
A pipeline is defined as a single R script with a schedule or input

Class for an individual maestro pipeline
A pipeline is defined as a single R script with a schedule or input
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MaestroPipeline-new}{\code{MaestroPipeline$new()}}
\item \href{#method-MaestroPipeline-print}{\code{MaestroPipeline$print()}}
\item \href{#method-MaestroPipeline-run}{\code{MaestroPipeline$run()}}
\item \href{#method-MaestroPipeline-get_pipe_name}{\code{MaestroPipeline$get_pipe_name()}}
\item \href{#method-MaestroPipeline-get_schedule}{\code{MaestroPipeline$get_schedule()}}
\item \href{#method-MaestroPipeline-check_timeliness}{\code{MaestroPipeline$check_timeliness()}}
\item \href{#method-MaestroPipeline-get_status}{\code{MaestroPipeline$get_status()}}
\item \href{#method-MaestroPipeline-get_status_chr}{\code{MaestroPipeline$get_status_chr()}}
\item \href{#method-MaestroPipeline-get_outputs}{\code{MaestroPipeline$get_outputs()}}
\item \href{#method-MaestroPipeline-get_inputs}{\code{MaestroPipeline$get_inputs()}}
\item \href{#method-MaestroPipeline-get_artifacts}{\code{MaestroPipeline$get_artifacts()}}
\item \href{#method-MaestroPipeline-get_errors}{\code{MaestroPipeline$get_errors()}}
\item \href{#method-MaestroPipeline-get_warnings}{\code{MaestroPipeline$get_warnings()}}
\item \href{#method-MaestroPipeline-get_messages}{\code{MaestroPipeline$get_messages()}}
\item \href{#method-MaestroPipeline-update_inputs}{\code{MaestroPipeline$update_inputs()}}
\item \href{#method-MaestroPipeline-update_outputs}{\code{MaestroPipeline$update_outputs()}}
\item \href{#method-MaestroPipeline-clone}{\code{MaestroPipeline$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-new"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-new}{}}}
\subsection{Method \code{new()}}{
Create a new Pipeline object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$new(
  script_path,
  pipe_name,
  frequency = NA_character_,
  start_time = lubridate::NA_POSIXct_,
  tz = NA_character_,
  hours = NULL,
  days = NULL,
  months = NULL,
  skip = FALSE,
  log_level = "INFO",
  inputs = NULL,
  outputs = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{script_path}}{path to the script}

\item{\code{pipe_name}}{name of the pipeline}

\item{\code{frequency}}{frequency of the pipeline (e.g., 1 day)}

\item{\code{start_time}}{start time of the pipeline}

\item{\code{tz}}{time zone of the pipeline}

\item{\code{hours}}{specific hours of the day}

\item{\code{days}}{specific days of week or month}

\item{\code{months}}{specific months of year}

\item{\code{skip}}{whether to skip the pipeline regardless of scheduling}

\item{\code{log_level}}{log level of the pipeline}

\item{\code{inputs}}{names of pipelines that this pipeline is dependent on for input}

\item{\code{outputs}}{names of pipelines for which this pipeline is a dependency}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
MaestroPipeline object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-print"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-print}{}}}
\subsection{Method \code{print()}}{
Prints the pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
print
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-run"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-run}{}}}
\subsection{Method \code{run()}}{
Runs the pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$run(
  resources = list(),
  log_file = tempfile(),
  quiet = FALSE,
  log_file_max_bytes = 1e+06,
  .input = NULL,
  cli_prepend = "",
  log_to_console = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{resources}}{named list of arguments and values to pass to the pipeline}

\item{\code{log_file}}{path to the log file for logging}

\item{\code{quiet}}{whether to silence console output}

\item{\code{log_file_max_bytes}}{maximum bytes of the log file before trimming}

\item{\code{.input}}{input values from upstream pipelines}

\item{\code{cli_prepend}}{text to prepend to cli output}

\item{\code{log_to_console}}{whether or not to output statements in the console (FALSE is to suppress and append to log)}

\item{\code{...}}{additional arguments (unused)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-get_pipe_name"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-get_pipe_name}{}}}
\subsection{Method \code{get_pipe_name()}}{
Get the pipeline name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$get_pipe_name()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
pipeline_name
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-get_schedule"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-get_schedule}{}}}
\subsection{Method \code{get_schedule()}}{
Get the schedule as a data.frame
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$get_schedule()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
data.frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-check_timeliness"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-check_timeliness}{}}}
\subsection{Method \code{check_timeliness()}}{
Check whether a pipeline is scheduled to run based on orchestrator frequency and current time
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$check_timeliness(
  orch_unit,
  orch_n,
  check_datetime = lubridate::now(),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{orch_unit}}{unit of the orchestrator (e.g., day)}

\item{\code{orch_n}}{number of units of the frequency}

\item{\code{check_datetime}}{datetime against which to check the timeliness of the pipeline (should almost always be now)}

\item{\code{...}}{unused}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
MaestroPipeline
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-get_status"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-get_status}{}}}
\subsection{Method \code{get_status()}}{
Get status of the pipeline as a data.frame
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$get_status()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
data.frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-get_status_chr"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-get_status_chr}{}}}
\subsection{Method \code{get_status_chr()}}{
Get status of the pipeline as a string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$get_status_chr()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-get_outputs"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-get_outputs}{}}}
\subsection{Method \code{get_outputs()}}{
Names of pipelines that receive input from this pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$get_outputs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-get_inputs"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-get_inputs}{}}}
\subsection{Method \code{get_inputs()}}{
Names of pipelines that input into this pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$get_inputs()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
character
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-get_artifacts"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-get_artifacts}{}}}
\subsection{Method \code{get_artifacts()}}{
Get artifacts (return values) from the pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$get_artifacts()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-get_errors"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-get_errors}{}}}
\subsection{Method \code{get_errors()}}{
Get list of errors from the pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$get_errors()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-get_warnings"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-get_warnings}{}}}
\subsection{Method \code{get_warnings()}}{
Get list of warnings from the pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$get_warnings()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-get_messages"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-get_messages}{}}}
\subsection{Method \code{get_messages()}}{
Get list of messages from the pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$get_messages()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-update_inputs"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-update_inputs}{}}}
\subsection{Method \code{update_inputs()}}{
Update the inputs of a pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$update_inputs(inputs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inputs}}{character vector of inputting pipeline names}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-update_outputs"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-update_outputs}{}}}
\subsection{Method \code{update_outputs()}}{
Update the outputs of a pipeline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$update_outputs(outputs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{outputs}}{character vector of outputting pipeline names}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MaestroPipeline-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MaestroPipeline-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MaestroPipeline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
