% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-dictionaries_functions.R
\name{data_dict_extract}
\alias{data_dict_extract}
\title{Generate a data dictionary from a dataset}
\usage{
data_dict_extract(dataset, as_data_dict_mlstr = TRUE)
}
\arguments{
\item{dataset}{A dataset object.}

\item{as_data_dict_mlstr}{Whether the input data dictionary should be coerced
with specific format restrictions for compatibility with other
Maelstrom Research software. TRUE by default.}
}
\value{
A list of data frame(s) representing metadata of the dataset variables.
}
\description{
Generates a data dictionary from a dataset. If the dataset variables have no
associated metadata, a minimum data dictionary is created by using variable
attributes.
}
\details{
A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.

A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.

The object may be specifically formatted to be compatible with additional
\href{https://maelstrom-research.org/page/software}{Maelstrom Research software},
in particular \href{https://www.obiba.org/pages/products/opal/}{Opal environments}.
}
\examples{
{

# use madshapR_DEMO provided by the package

###### Example 2: extract data dictionary from any dataset (the 
# data dictionary will be created upon attributes of the dataset. Factors 
# will be considered as categorical variables)
data_dict_extract(iris)

}

}
