% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examinee_class.R
\docType{class}
\name{examinee-class}
\alias{examinee-class}
\title{Class 'examinee': a single examinee}
\description{
\code{\linkS4class{examinee}} is an S4 class to represent a single examinee.
}
\section{Slots}{

\describe{
\item{\code{examinee_id}}{the ID of examinee.}

\item{\code{current_grade}}{the current grade the examinee is in. Updated using \code{\link{updateGrade}}.}

\item{\code{current_phase}}{the current phase the examinee is in. Updated using \code{\link{updatePhase}}.}

\item{\code{current_test}}{the current test the examinee is in. Updated using \code{\link{updateTest}}.}

\item{\code{current_module}}{the current module the examinee is in. Updated using \code{\link{updateModule}}.}

\item{\code{grade_log}}{grades that the examinee belonged at each module position. Updated using \code{\link{updateLog}}.}

\item{\code{phase_log}}{phases that the examinee belonged at each module position. Updated using \code{\link{updateLog}}.}

\item{\code{test_log}}{tests that the examinee belonged at each module position. Updated using \code{\link{updateLog}}.}

\item{\code{module_log}}{modules that the examinee belonged at each module position. Updated using \code{\link{updateLog}}.}

\item{\code{n_module}}{the number of modules the examinee received. This is the number of module positions.}

\item{\code{true_theta}}{a vector containing the true theta (if simulated) of the examinee, for each module position.}

\item{\code{initial_theta_in_module}}{a vector containing initial thetas used in each module.}

\item{\code{prior_par_by_module}}{a list containing prior parameters used for each module.}

\item{\code{estimated_theta_by_phase}}{a list containing estimated thetas and SEs using items in each phase.}

\item{\code{estimated_theta_by_test}}{a list containing estimated thetas and SEs using combined items in each test. Updated using \code{\link{updateThetaUsingCombined}}.}

\item{\code{estimated_theta_for_routing}}{a list containing estimated thetas and SEs that were used for routing. Updated using \code{\link{updateThetaForRouting}}.}

\item{\code{estimated_theta}}{a list containing estimated theta and SE using all responses from all modules. Updated using \code{\link{updateAssessmentLevelTheta}}.}

\item{\code{alpha}}{the alpha value used to compute lower and upper bounds.}

\item{\code{selection_theta}}{a list containing selection thetas in each module position.}

\item{\code{interim_theta}}{a list containing interim thetas and SEs in each module position.}

\item{\code{administered_items}}{a list containing administered items in each module position.}

\item{\code{administered_stimuli}}{a list containing administered stimuli in each module position.}

\item{\code{response}}{a list containing the examinee response in each module position.}

\item{\code{item_data}}{a list containing \code{\linkS4class{item_pool}} of administered items.}

\item{\code{routing_based_on}}{a vector containing the routing was based on \code{estimated_theta_by_phase} or {estimated_theta_by_test} at each module position.}
}}

