% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch-full-msg.R
\name{fetch_full_msg}
\alias{fetch_full_msg}
\title{Fetch Full Messages}
\usage{
fetch_full_msg(imapconf, msg_id, by = "MSN", peek = TRUE,
  partial = NULL, write_to_disk = FALSE, keep_in_mem = TRUE,
  retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{msg_id}{A numeric vetor containing one or more messages ids.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{peek}{If \code{TRUE}, it does not mark messages as "read" after
fetching. Default is \code{TRUE}.}

\item{partial}{\code{NULL} or a character string with format
"startchar.endchar" indicating the size (in characters) of a message slice
to fetch. Default is \code{NULL}, which fetchs the full specified content.}

\item{write_to_disk}{If \code{TRUE} writes fetch content of each message
to the disk as a text file in the working directory. Default is \code{FALSE}.}

\item{keep_in_mem}{If \code{TRUE} keeps a copy of fetch results as an
list in the R session when \code{write_to_disk = TRUE}. Default is
\code{TRUE}. It can only be set \code{FALSE} when
\code{write_to_disk = TRUE}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
A \code{list} or/and text files containing the fetch results.
}
\description{
Fetch all the sections and fields of one or more messages.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )

# fetching
results <- imapconf \%>\%
    select_mailbox(mbox = "TAM") \%>\%
    search_before(date_char = "10-may-2012", by = "UID") \%$\% #exposition pipe - two argg
    fetch_full_msg(imapconf = imapconf,
                   msg_id = msg_id,
                   by="UID", write_to_disk = TRUE,
                   keep_in_mem = FALSE,
                   partial = "0.789")

}

}
\seealso{
Other fetch: \code{\link{fetch_msg_header}},
  \code{\link{fetch_msg_metadata}},
  \code{\link{fetch_msg_text}}
}
\concept{fetch}
