% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/before.R
\name{before}
\alias{before}
\title{Criteria Helper Functions for Custom Search}
\usage{
before(date_char, negate = FALSE)
}
\arguments{
\item{date_char}{A character vector with format "DD-Mon-YYYY",
e.g. "01-Apr-2019". We opted not to use objects of type "date", since IMAP
servers like this not so common date format.}

\item{negate}{If \code{TRUE}, negates the search and seeks for
"NOT search_criterion". Default is \code{FALSE}.}
}
\value{
A search string to be used as a \code{custom_request} parameter in
    \link{custom_search} function.
}
\description{
Criteria helper functions to be combined inside a operator helper
    function as a custom request in \link{custom_search}.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )

# search
result <- imapconf \%>\%
    select_mailbox(mbox = "INBOX") \%>\%
    custom_search(custom_request = AND(before(date_char = "17-Apr-2019"),
                                       smaller_than(size = 512000),
                                       negate = TRUE))
# searches for messages NOT Before "17-Apr-2019" AND NOT Smaller Than  512KB.

}

}
\seealso{
Other customsearch helper functions: \code{\link{AND}},
  \code{\link{OR}}, \code{\link{flag}},
  \code{\link{larger_than}}, \code{\link{older_than}},
  \code{\link{on}}, \code{\link{sent_before}},
  \code{\link{sent_on}}, \code{\link{sent_since}},
  \code{\link{since}}, \code{\link{smaller_than}},
  \code{\link{string}}, \code{\link{younger_than}}
}
\concept{customsearch helper functions}
