% Generated by roxygen2 (4.0.2): do not edit by hand
\name{asianOption}
\alias{asianOption}
\title{Asian Option Price}
\usage{
asianOption(S, K, r, delta, sigma, t = 1, call = TRUE, arithmetic = TRUE,
  price = TRUE, h = 10)
}
\arguments{
\item{S}{the initial stock price}

\item{K}{the strike price}

\item{r}{the risk free (continuously compounded interest rate)}

\item{delta}{the annual dividend rate}

\item{sigma}{the volatility}

\item{t}{the expiration time (default one year)}

\item{call}{TRUE if option is a call, FALSE is option is a put}

\item{arithmetic}{TRUE if arithmetic average is used, FALSE if geometric average is used}

\item{price}{TRUE if average price is used, FALSE if average strike is used}

\item{h}{the number of subdivisions between 0 and t (default 10)}
}
\description{
Returns the price of an asian option using a binomial tree approach
}
\details{
Uses a forward tree to compute u and d. p is the risk-neutral probability
}
\examples{
asianOption(40, 39, 0.05, 0, 0.3, 3/12, call=FALSE, arithmetic=TRUE, price=TRUE, h=3)
}

