% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy_means.R
\name{loa}
\alias{loa}
\title{Limits of agreement}
\usage{
loa(actual, predicted, na.rm = FALSE)
}
\arguments{
\item{actual}{A numeric vector with the actual values.}

\item{predicted}{A numeric vector with the predicted values. Each element in
this vector must be a prediction for the corresponding element in
\code{actual}.}

\item{na.rm}{A logical value indicating whether \code{NA} values should be
stripped before the computation proceeds. Defaults to \code{FALSE}.}
}
\value{
A named list with the lower and upper limits of agreement values,
respectively.
}
\description{
Computes the Bland-Altman limits of agreement between the input vectors.
}
\examples{
actual <- runif(10)
predicted <- runif(10)

loa(actual, predicted)
}
\seealso{
\code{\link[=mean_error]{mean_error()}},
\code{\link[=bias]{bias()}}
}
