% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/total.R
\name{total}
\alias{total}
\title{Total number of cells in a categorical Raster* object}
\usage{
total(x, categories)
}
\arguments{
\item{x}{Raster* object}

\item{categories}{numeric vector containing land use categories. Only cells
  belonging to these categories will be counted}
}
\value{
A list containing the following components:
\describe{
  \item{\code{total}}{a matrix containing the total number of cells belonging
    to each category. Rows represent layers in the input Raster* object}
  \item{\code{categories}}{the categories included in the calculation}
}
}
\description{
Count the number of cells belonging to each category in a Raster* object.
}
\examples{
## Sibuyan Island

## load observed land use data
obs <- ObsLulcRasterStack(x=sibuyan$maps,
                    pattern="lu",
                    categories=c(1,2,3,4,5),
                    labels=c("Forest","Coconut","Grass","Rice","Other"),
                    t=c(0,14))

total(x=obs)
total(x=obs[[1]])
total(x=obs[[2]])
}

