% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_han2018.R
\name{test_han2018}
\alias{test_han2018}
\title{Association testing using Han & Lahiri estimating equations and jackknife approach}
\usage{
test_han2018(
  match_prob,
  y,
  x,
  covar_y = NULL,
  covar_x = NULL,
  jackknife_nrep = 100,
  jackknife_blocksize = max(floor(min(length(y), nrow(x))/jackknife_nrep), 1),
  methods = c("F", "M", "M2"),
  dist_family = c("gaussian", "binomial")
)
}
\arguments{
\item{match_prob}{matching probabilities matrix (e.g. obtained through \code{\link{recordLink}}) of 
dimensions \code{n1 x n2}.}

\item{y}{response variable of length \code{n1}. Only binary or gaussian phenotypes 
are supported at the moment.}

\item{x}{a \code{matrix} or a \code{data.frame} of predictors of dimensions \code{n2 x p}. 
An intercept is automatically added within the function.}

\item{covar_y}{a \code{matrix} or a \code{data.frame} of predictors of dimensions \code{n1 x q1}. 
An intercept is automatically added within the function.}

\item{covar_x}{a \code{matrix} or a \code{data.frame} of predictors of dimensions \code{n2 x q2}. 
An intercept is automatically added within the function.}

\item{jackknife_nrep}{the number of jackknife repetitions.
Default is 100 (from Han et al.).}

\item{jackknife_blocksize}{the number of observations to remove in each jackknife.}

\item{methods}{a character vector which must be a subset of \code{("F", "M", "M2")} 
indicating which estimator from Han et al. 2018 should be computed. Default is all 3.}

\item{dist_family}{a character string indicating the distribution family for the glm. 
Currently, only \code{'gaussian'} and  \code{'binomial'} are supported. Default 
is \code{'gaussian'}.}
}
\value{
a list containing the following for each estimator in \code{methods}:
\itemize{
  \item \code{beta} a vector containing the \code{p} estimated coefficients
  \item \code{varcov} the \code{p x p} variance-covariance \code{matrix} of the \code{beta} coefficients
  \item \code{zscores} a vector containing the \code{p} Z-scores
  \item \code{pval} the corresponding Gaussian assumption p-values
}
}
\description{
Association testing using Han & Lahiri estimating equations and jackknife approach
}
\examples{
# rm(list=ls())
# n_sims <- 500
# res <- pbapply::pblapply(1:n_sims, function(n){
# nx <- 99
# ny <- 103
# x <- matrix(ncol=2, nrow=ny, stats::rnorm(n=ny*2))
# 
# #plot(density(rbeta(n=1000, 1,2)))
# match_prob <- diag(ny)[, 1:nx]#matrix(rbeta(n=ny*nx, 1, 2), nrow=ny, ncol=99)
# 
# covar_y <- matrix(rnorm(n=ny, 1, 0.5), ncol=1)
# covar_x <- matrix(ncol=3, nrow=ny, stats::rnorm(n=ny*3))
# 
# #y <- rnorm(n=ny, mean = x \%*\% c(2,-3)  + covar_x \%*\% rep(0.2, ncol(covar_x)) + 0.5*covar_y, 0.5)
# y <- rbinom(n=ny, 1, prob=expit(x \%*\% c(2,-3)  + covar_x \%*\% 
#             rep(0.2, ncol(covar_x)) + 0.5*covar_y))
# #glm(y~0+x+covar_y+covar_x, family = "binomial")
# return(
# #test_han2018(match_prob, y, x, jackknife_blocksize = 10, covar_x = NULL, covar_y = NULL)
# test_han2018(match_prob, y[1:ny], x[1:nx, ], dist_family = "binomial", 
#              jackknife_blocksize = 10, covar_x = covar_x[1:nx, ], 
#              covar_y = covar_y[1:ny, , drop=FALSE])
# )
# }, cl=parallel::detectCores()-1)
# pvals_F <- sapply(lapply(res, "[[", "F"), "[[", "beta")
# pvals_M <- sapply(lapply(res, "[[", "M"), "[[", "beta")
# pvals_M2 <- sapply(lapply(res, "[[", "M2"), "[[", "beta")
# quantile(pvals_F)
# quantile(pvals_M)
# quantile(pvals_M2)
# rowMeans(pvals_F<0.05)
# rowMeans(pvals_M<0.05)
# rowMeans(pvals_M2<0.05)

}
\references{
Han, Y., and Lahiri, P. (2019) Statistical Analysis with Linked Data. 
International Statistical Review, 87: S139– S157. 
\doi{10.1111/insr.12295}.
}
