% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.r
\name{hm}
\alias{hm}
\title{Create a period with the specified number of hours and minutes}
\usage{
hm(..., quiet = FALSE)
}
\arguments{
\item{...}{character or numeric vectors of hour minute pairs}

\item{quiet}{logical. When TRUE function evalueates without displaying customary messages.}
}
\value{
a vector of class \code{Period}
}
\description{
Transforms a character or numeric vectors into a period object with the
specified number of hours and minutes. Arbitrary non-numeric text can
separate hours and minutes.  After hours and minutes have been parsed, the
remaining input is ignored.
}
\examples{
hm(c("09:10", "09:02", "1:10"))
## [1] "9H 10M 0S" "9H 2M 0S"  "1H 10M 0S"
hm("7 6")
## [1] "7H 6M 0S"
hm("6,5")
## [1] "6H 5M 0S"
}
\seealso{
\code{\link{hms}, \link{ms}}
}
\keyword{period}

