% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot.lsbclust.R
\name{plot.lsbclust}
\alias{plot.lsbclust}
\title{Plot method for class 'lsbclust'}
\usage{
\method{plot}{lsbclust}(x, type = c("overall", "rows", "columns",
  "interactions"), biplot.axes = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{orc.kmeans}}

\item{type}{A character vector indicating which component(s) of \code{x} to plot: a combination of
\code{"overall"}, \code{"rows"}, \code{"columns"} and \code{"interactions"}.}

\item{biplot.axes}{A logical indicating whether to plot calibrated biplot axes for the line
segments indicated in \code{segments} or not.}

\item{\dots}{additional arguments passed to the plot methods of the respective components, typically
to \code{\link{theme}}. Use e.g. \code{plot(x$interactions)} for more control over the respective
plots.}
}
\description{
This plot method simply plots each of the components in the list of class \code{lsbclust}.
}
\examples{
data("dcars")
m <- lsbclust(data = dcars, margin = 3, delta = c(1, 1, 1, 1), nclust = 5, nstart = 1)
plot(m)
}
\author{
Pieter C. Schoonees
}
\seealso{
\code{\link{plot.int.lsbclust}}, \code{\link{plot.ovl.kmeans}},
\code{\link{plot.row.kmeans}}, \code{\link{plot.col.kmeans}}
}
\keyword{hplot}

