% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignMeans.R
\name{getDesignSlopeDiffMMRM}
\alias{getDesignSlopeDiffMMRM}
\title{Power and sample for two-sample slope difference
from the MMRM model}
\usage{
getDesignSlopeDiffMMRM(
  beta = NA_real_,
  n = NA_real_,
  slopeDiffH0 = 0,
  slopeDiff = 0.5,
  stDev = 1,
  stDevIntercept = 1,
  stDevSlope = 1,
  corrInterceptSlope = 0.5,
  k = NA_integer_,
  t = NA_real_,
  cumdrop1 = rep(0, k),
  cumdrop2 = NA_real_,
  allocationRatioPlanned = 1,
  normalApproximation = TRUE,
  rounding = TRUE,
  alpha = 0.025
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{slopeDiffH0}{The slope difference under the null hypothesis.
Defaults to 0.}

\item{slopeDiff}{The slope difference under the alternative
hypothesis.}

\item{stDev}{The standard deviation of the residual.}

\item{stDevIntercept}{The standard deviation of the random intercept.}

\item{stDevSlope}{The standard deviation of the random slope.}

\item{corrInterceptSlope}{The correlation between the random
intercept and random slope.}

\item{k}{The number of time points including the baseline.}

\item{t}{The time points. It should have \code{k} elements,
start with 0 corresponding to the baseline time point, and
be increasing.}

\item{cumdrop1}{The cumulative dropout rate at the given
time points for the active treatment group.}

\item{cumdrop2}{The cumulative dropout rate at the given
time points for the control group. If missing, it will be set
equal to the cumulative dropout rate for the active treatment group.}

\item{allocationRatioPlanned}{Allocation ratio for the active
treatment versus control. Defaults to 1 for equal randomization.}

\item{normalApproximation}{The type of computation of the p-values.
If \code{TRUE}, the variance is assumed to be known, otherwise
the calculations are performed with the t distribution.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The one-sided significance level. Defaults to 0.025.}
}
\value{
An S3 class \code{designSlopeDiffMMRM} object with the following
components:
\itemize{
\item \code{power}: The power to reject the null hypothesis.
\item \code{alpha}: The one-sided significance level.
\item \code{numberOfSubjects}: The maximum number of subjects.
\item \code{slopeDiffH0}: The slope difference under the null hypothesis.
\item \code{slopeDiff}: The slope difference under the alternative
hypothesis.
\item \code{stDev}: The standard deviation of the residual.
\item \code{stDevIntercept}: The standard deviation of the random
intercept.
\item \code{stDevSlope}: The standard deviation of the random slope.
\item \code{corrInterceptSlope}: The correlation between the random
intercept and random slope.
\item \code{k}: The number of time points including the baseline.
\item \code{t}: The time points.
\item \code{cumdrop1}: The cumulative dropout rate at the given
time points for the active treatment group.
\item \code{cumdrop2}: The cumulative dropout rate at the given
time points for the control group.
\item \code{calculationTarget}: The calculation target, \code{beta} or
\code{n}.
\item \code{allocationRatioPlanned}: Allocation ratio for the active
treatment versus control.
\item \code{normalApproximation}: The type of computation of the p-values.
If \code{TRUE}, the variance is assumed to be known, otherwise
the calculations are performed with the t distribution.
\item \code{rounding}: Whether to round up sample size.
}
}
\description{
Obtains the power given sample size or obtains the sample
size given power for two-sample slope difference from the growth curve
MMRM model.
}
\details{
We use the following random-effects model to compare two slopes:
\deqn{y_{ij} = \alpha + (\beta + \gamma x_i) t_j + a_i + b_i t_j
+ e_{ij},} where
\itemize{
\item \eqn{\alpha}: overall intercept common across treatment groups
due to randomization
\item \eqn{\beta}: slope for the control group
\item \eqn{\gamma}: difference in slope between the active treatment and
control groups
\item \eqn{x_i}: treatment indicator for subject \eqn{i},
1 for the active treatment and 0 for the control
\item \eqn{t_j}: time point \eqn{j} for repeated measurements,
\eqn{t_1 = 0 < t_2 < \ldots < t_k}
\item \eqn{(a_i, b_i)}: random intercept and random slope
for subject \eqn{i}, \eqn{Var(a_i) = \sigma_a^2},
\eqn{Var(b_i) = \sigma_b^2}, \eqn{Corr(a_i, b_i) = \rho}
\item \eqn{e_{ij}}: within-subject residual with variance \eqn{\sigma_e^2}
}

By accounting for randomization, we improve the efficiency for
estimating the difference in slope. We also allow for non-equal
spacing of the time points and missing data due to dropouts.
}
\examples{

(design1 <- getDesignSlopeDiffMMRM(
  beta = 0.1, n = NA, slopeDiff = -1,
  stDev = 4, stDevIntercept = 10,
  stDevSlope = 6, corrInterceptSlope = 0.5,
  k = 7, t = seq(0, 6),
  normalApproximation = TRUE, alpha = 0.025))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
