% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{updateGraph}
\alias{updateGraph}
\title{Update graph for graphical approaches}
\usage{
updateGraph(w, G, I, j)
}
\arguments{
\item{w}{The current vector of weights for elementary hypotheses.}

\item{G}{The current transition matrix.}

\item{I}{The set of indices for yet to be rejected hypotheses.}

\item{j}{The hypothesis to remove from index set \code{I}.}
}
\value{
A list containing the new vector of weights and the new
transition matrix for the graph, and the new set of indices of yet
to be rejected hypotheses.
}
\description{
Updates the weights and transition matrix for graphical
approaches.
}
\examples{
updateGraph(w = c(0.5, 0.5, 0, 0), 
            G = matrix(c(0, 0.5, 0.5, 0,  0.5, 0, 0, 0.5,  
                         0, 1, 0, 0,  1, 0, 0, 0), 
                       nrow=4, ncol=4, byrow=TRUE), 
            I = c(1, 2, 3, 4), 
            j = 1)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
