% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cluster_BIC}
\alias{cluster_BIC}
\title{Calculates BIC for a given clustering.}
\usage{
cluster_BIC(data, centres)
}
\arguments{
\item{data}{a matrix (n x m). Rows are observations, columns are predictors.}

\item{centres}{matrix of cluster means (k x m), where k is the number of clusters.}
}
\value{
BIC value
}
\description{
Computes Bayesian information criterion for a given clustering of a data set.
}
\details{
Bayesian information criterion (BIC) is calculated using the formula, BIC =  -2 * log(L) + k*log(n).
k is the number of free parameters, in this case is m*k + k - 1.
n is the number of observations (rows of data).
L is the liklihood for the given set of cluster centres.
}
\examples{
iris_mat <- as.matrix(iris[,1:4])
iris_centres2 <- tkmeans(iris_mat, 2 , 0.1, c(1,1,1,1), 1, 10, 0.001) # 2 clusters
iris_centres3 <- tkmeans(iris_mat, 3 , 0.1, c(1,1,1,1), 1, 10, 0.001) # 3 clusters
cluster_BIC(iris_mat, iris_centres2)
cluster_BIC(iris_mat, iris_centres3)
}

