% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/loo_and_waic.R
\name{loo_and_waic}
\alias{loo_and_waic}
\title{Approximate LOO-CV and WAIC for Bayesian models}
\usage{
loo_and_waic(log_lik, ...)
}
\arguments{
\item{log_lik}{an \eqn{S} by \eqn{N} matrix, where \eqn{S} is the size of the
posterior sample (the number of simulations) and \eqn{N} is the number of
data points. Typically (but not restricted to be) the object returned by
\code{\link{extract_log_lik}}.}

\item{...}{optional arguments to pass to \code{\link{vgislw}}. Possible
arguments and their defaults are:
\describe{
\item{\code{wcp = 0.2}}{the proportion of importance weights to use for the
generalized Pareto fit. The \code{100*wcp}\% largest weights are used as the
sample from which to estimate the parameters \eqn{k} and \eqn{\sigma} of
the generalized Pareto distribution.}
\item{\code{thresh = 100}}{when used for the generalized Pareto fit, the
largest \code{100*wcp}\% of the importance weights are modified according to
\code{pmax(x, max(x) - thresh)} for numerical stability.}
\item{\code{kmax = 2}}{the maximum allowed value for the generalized Pareto
shape parameter \eqn{k}.}
\item{\code{wtrunc = 3/4}}{for truncating very large weights to
\eqn{S}^\code{wtrunc} (set to zero for no truncation).}
\item{\code{cores = \link[parallel]{detectCores}()}}{the number of cores to
     use for parallelization.}
}

We recommend using the default values for the \code{vgislw} arguments unless
there are problems (e.g. \code{NA} or \code{NaN} results).}
}
\value{
a named list with class \code{'loo'}.

Returned for both LOO and WAIC are the expected log pointwise predictive
density (\code{elpd}), the estimated effective number of parameters
(\code{p}), and the information criteria on the deviance scale (e.g.
\code{looic = -2*elpd_loo}). Also returned are the pointwise contributions of
each of these measures, standard errors, and the estimated shape parameter
\eqn{k} for the Pareto fit to the importance ratios for each leave-one-out
distribution.
}
\description{
Approximate LOO-CV and WAIC for Bayesian models
}
\examples{
\dontrun{
log_lik <- extract_log_lik(stanfit)
loo <- loo_and_waic(log_lik)
print(loo, digits = 3)
}
}
\seealso{
\code{\link{loo-package}}, \code{\link{print.loo}},
\code{\link{loo_and_waic_diff}}
}

