% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruning.R
\name{prune.path}
\alias{prune.path}
\title{Pruning path of a logic decision tree}
\usage{
prune.path(pet, y, Z)
}
\arguments{
\item{pet}{A fitted logic decision tree. This can be extracted from a
\code{\link{logicDT}} model, e.g., using \code{model$pet}.}

\item{y}{Training outcomes for potentially refitting regression models in
the leaves. This can be extracted from a \code{\link{logicDT}} model,
e.g., using \code{model$y}.}

\item{Z}{Continuous training predictors for potentially refitting regression
models in the leaves. This can be extracted from a \code{\link{logicDT}}
model, e.g., using \code{model$Z}. If no continuous covariable was used in
fitting the model, \code{Z = model$Z = NULL} should be specified.}
}
\value{
Two lists. The first contains the sequence of complexity penalties
  \eqn{alpha}. The second list contains the corresponding logic decision
  trees which can then be substituted in an already fitted
  \code{\link{logicDT}} model, e.g., using
  \code{model$pet <- result[[2]][[i]]} where \code{result} is the returned
  object from this function and \code{i} is the chosen tree index.
}
\description{
Using a single fitted logic decision tree, the cost-complexity pruning path
containing the ideal subtree for a certain complexity penalty can be
computed.
}
\details{
This is mainly a helper function for \code{\link{cv.prune}} and should only
be used by the user if manual pruning is preferred.
More details are given in \code{\link{cv.prune}}.
}
