% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clmi.R
\name{clmi}
\alias{clmi}
\title{Censored Likelihood Multiple Imputation}
\usage{
clmi(formula, df, lod, seed, n.imps = 5)
}
\arguments{
\item{formula}{A formula in the form of \code{exposure ~ outcome + covariates}.}

\item{df}{A data.frame with \code{exposure}, \code{outcome} and
\code{covariates}.}

\item{lod}{Name of limit of detection variable in \code{df}.}

\item{seed}{For reproducability.}

\item{n.imps}{Number of datasets to impute. Default is 5.}
}
\description{
This function performs censored likelihood multiple imputation for
single-pollutant models where the pollutant of interest is subject to
varying detection limits across batches (this function will also work if
there is only one distinct detection limit). The function
outputs a list containing the imputed datasets and details regarding the
imputation procedure (i.e., number of imputed dataset, covariates used to
impute the non-detects, etc).
}
\note{
\code{clmi} only supports categorical variables that are numeric,
  (i.e., not factors or characters). You can use the \code{model.matrix}
  function to convert a data frame with factors to a numeric design matrix
  and subsequently convert that matrix back into a data frame using
  \code{as.data.frame}.
}
\examples{
library(lodi)
data("toy_data")
# run clmi
clmi.out <- clmi(poll ~ case_cntrl + smoking + gender, toy_data, lod, 1)

# you can specify a transformation to the exposure in the formula
clmi.out <- clmi(log(poll) ~ case_cntrl + smoking + gender, toy_data, lod, 1)

}
\references{
Boss J, Mukherjee B, Ferguson KK, et al. Estimating outcome-exposure
  associations when exposure biomarker detection limits vary across
  batches. *Epidemiology*. 2019. Epub ahead of print.
  [10.1097/EDE.0000000000001052](https://doi.org/10.1097/EDE.0000000000001052)
}
