% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lint.R
\name{lint_dir}
\alias{lint_dir}
\title{Lint a directory}
\usage{
lint_dir(
  path = ".",
  relative_path = TRUE,
  ...,
  exclusions = NULL,
  pattern = rex::rex(".", one_of("Rr"), end),
  parse_settings = TRUE
)
}
\arguments{
\item{path}{the path to the base directory, by default,
it will be searched in the parent directories of the current directory.}

\item{relative_path}{if \code{TRUE}, file paths are printed using their path
relative to the base directory.  If \code{FALSE}, use the full
absolute path.}

\item{...}{additional arguments passed to \code{\link{lint}}, e.g.
\code{cache} or \code{linters}.}

\item{exclusions}{exclusions for \code{\link{exclude}}, relative to the
package path.}

\item{pattern}{pattern for files, by default it will take files with .R or .r extension.}

\item{parse_settings}{whether to try and parse the settings}
}
\value{
A list of lint objects.
}
\description{
Apply one or more linters to all of the R files in a directory
}
\examples{
\dontrun{
  lint_dir()
  lint_dir(
    linters = list(semicolon_terminator_linter())
    cache = TRUE,
    exclusions = list("inst/doc/creating_linters.R" = 1, "inst/example/bad.R")
  )
}
}
