% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggmap.feature.R
\name{ggmap.feature}
\alias{ggmap.feature}
\title{Create a map with ggplot2}
\usage{
ggmap.feature(languages, features = "", latitude = NA,
  longitude = NA, color = NULL, title = NULL, legend = TRUE,
  width = 2, opacity = 1, map.orientation = "Atlantic",
  glottolog.source = "modified")
}
\arguments{
\item{languages}{character vector of languages (can be written in lower case).}

\item{features}{character vector of features.}

\item{latitude}{numeric vector of latitudes.}

\item{longitude}{numeric vector of longitudes.}

\item{color}{vector of colors or palette. The color argument can be (1) a character vector of RGM or named colors; (2) the name of an RColorBrewer palette; (3) the full name of a viridis palette; (4) a function that receives a single value between 0 and 1 and returns a color. For more examples see \code{\link{colorNumeric}}.}

\item{title}{title of a legend.}

\item{legend}{logical. If TRUE, function show legend. By default is TRUE.}

\item{width}{a numeric vector of radius for circles or width for barcharts in minicharts.}

\item{opacity}{a numeric vector of marker opacity.}

\item{map.orientation}{a character verctor with values "Pacific" and "Atlantic". It distinguishes Pacific-centered and Atlantic-centered maps. By default is "Atlantic".}

\item{glottolog.source}{A character vector that define which glottolog database is used: "original" or "modified" (by default)}
}
\description{
Map a set of languages and color them by feature.
}
\examples{
ggmap.feature(c("Adyghe", "Russian"))

}
\author{
George Moroz <agricolamz@gmail.com>
}
