% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.dict.R
\name{download.dict}
\alias{download.dict}
\title{Download Dictionaries}
\usage{
download.dict(dict = "lusi", check.md5 = TRUE, mode = "wb",
  dir = getOption("lingmatch.dict.dir"), overwrite = FALSE)
}
\arguments{
\item{dict}{One or more names of dictionaries to download, or \code{'all'} for all available. See
\href{https://osf.io/y6g5b/wiki/home}{osf.io/y6g5b/wiki} for more information, and a list of available dictionaries.}

\item{check.md5}{Logical; if \code{TRUE} (default), retrieves the MD5 checksum from OSF,
and compares it with that calculated from the downloaded file to check its integrity.}

\item{mode}{A character specifying the file write mode; default is 'wb'. See
\code{\link{download.file}}.}

\item{dir}{Directory in which to save the dictionary; \cr default is \code{getOption('lingmatch.dict.dir')}. \cr
This must be specified, or the option must be set -- use \code{\link{lma_initdirs}} to initialize a directory.}

\item{overwrite}{Logical; if \code{TRUE}, will replace existing files.}
}
\value{
Path to the downloaded dictionary, or a list of such if multiple were downloaded.
}
\description{
Downloads the specified dictionaries from \href{https://osf.io/y6g5b}{osf.io/y6g5b}.
}
\examples{
\dontrun{

download.dict("lusi", dir = "~/Dictionaries")
}
}
\seealso{
Other Dictionary functions: 
\code{\link{lma_patcat}()},
\code{\link{lma_termcat}()},
\code{\link{read.dic}()},
\code{\link{select.dict}()}
}
\concept{Dictionary functions}
