% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_ordering_methods.R
\name{standardized_sums}
\alias{standardized_sums}
\title{Standardized sums method.}
\usage{
standardized_sums(decision, weights, impacts)
}
\arguments{
\item{decision}{A numeric matrix with m rows for m alternatives and n columns
for n criterions.}

\item{weights}{A numeric vector with length equal to number of columns in
decision matrix for weights of criterions.}

\item{impacts}{A character vector of '+' and '-' signs for the way that each
criterion influences on the alternatives.}
}
\value{
A data frame including elements:
\describe{
  \item{\code{alt.row}}{Row number of alternatives in decision matrix.}
  \item{\code{score}}{Score of alternatives.}
  \item{\code{rank}}{Rank of alternatives based on score.}
}
Should \code{decision} be a data frame, the row names will be carried over
to the return value.
Should \code{decision} be a data frame, the row names will be carried over
to the return value.
}
\description{
Standardized sums method.
}
\examples{
d <- matrix(rpois(12, 5), nrow = 3, ncol = 3)
w <- c(1, 1, 2)
i <- c('+', '-', '+')
standardized_sums(d, w, i)
}
\author{
Antoni Baum \email{antoni.baum@protonmail.com}
}
