% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_run.R
\name{run_model}
\alias{run_model}
\title{run_model}
\usage{
run_model(
  data = NULL,
  dv = NULL,
  ivs = NULL,
  trans_df = NULL,
  meta_data = NULL,
  id_var = NULL,
  model_table = NULL,
  verbose = FALSE,
  normalise_by_pool = FALSE,
  save_raw_data = TRUE,
  decompose = TRUE,
  categories = NULL
)
}
\arguments{
\item{data}{\code{data.frame} containing variables included in the model specification}

\item{dv}{string of the dependent variable name}

\item{ivs}{character vector of the independent variables names}

\item{trans_df}{\code{data.frame} defining the non-linear transformations to apply}

\item{meta_data}{\code{data.frame} mapping variable names to their roles (i.e. POOL)}

\item{id_var}{string of id variable name (e.g. date)}

\item{model_table}{\code{data.frame} as created in the \code{build_model_table} function}

\item{verbose}{A boolean to specify whether to print warnings}

\item{normalise_by_pool}{A boolean to specify whether to apply the normalisation}

\item{save_raw_data}{A boolean to specify whether to save all input data variables to the model object}

\item{decompose}{A boolean to specify whether to generate the model decomposition}

\item{categories}{\code{data.frame} mapping variables to groups}
}
\value{
Model object
}
\description{
Run a linear regression model
}
\details{
Run a linear regression model that captures the transformations applied in the \code{model_table} and the normalisation described in the \code{meta_data}.
A model can be run also by only supplying a dependent variable name \code{dv}, a vector of independent variable names dependent variable \code{ivs}, and the data that contains these.
}
\examples{
run_model(data = read_xcsv("https://raw.githubusercontent.com/paladinic/data/main/ecomm_data.csv"),
          dv = 'ecommerce',
          ivs = c('christmas','black.friday'))
run_model(data = mtcars,dv = 'mpg',ivs = c('disp','cyl'))
}
